package ru.yandex.chemodan.app.bazingaload.tasks;

import ru.yandex.chemodan.app.bazingaload.TasksManager;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.misc.time.Stopwatch;

public class CpuLoadTask extends AbstractLoadTask {

    private DynamicProperty<Double> loadFactor = new DynamicProperty<>("tasks--load-factor", 0.5);
    private DynamicProperty<Integer> loadTaskDuration =
            new DynamicProperty<>("tasks--load-duration-ms", 30000);

    public CpuLoadTask(DummyPayload parameters) {
        super(parameters);
    }

    public CpuLoadTask(TasksManager tasksManager) {
        super(tasksManager);
    }

    @Override
    protected void doWork() throws Exception {
        Stopwatch watch = Stopwatch.createAndStart();
        while (watch.millisDuration() < loadTaskDuration.get()) {
            // Every 100ms, sleep for the percentage of unladen time
            if (System.currentTimeMillis() % 100 == 0) {
                Thread.sleep((long) Math.floor((1 - loadFactor.get()) * 100));
            }
        }
    }
}
