package ru.yandex.chemodan.app.bazingaload.tasks;

import org.joda.time.Duration;

import ru.yandex.chemodan.app.bazingaload.TasksManager;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.dynproperties.DynamicProperty;

public class MultiplicationTask extends OnetimeTaskSupport<DummyPayload> {
    private TasksManager tasksManager;

    private DynamicProperty<Integer> sleepTasksCount = new DynamicProperty<>("tasks--sleep-tasks-to-produce", 0);
    private DynamicProperty<Integer> loadTasksCount = new DynamicProperty<>("tasks--load-tasks-to-produce", 0);
    private DynamicProperty<Integer> multiplicationTasksCount =
            new DynamicProperty<>("tasks--multiplication-tasks-to-produce", 2);
    private DynamicProperty<Integer> quickMoveTasksCount =
            new DynamicProperty<>("tasks--quick-move-tasks-to-produce", 0);

    public MultiplicationTask(DummyPayload parameters) {
        super(parameters);
    }

    public MultiplicationTask(TasksManager tasksManager) {
        super(DummyPayload.class);
        this.tasksManager = tasksManager;
    }


    @Override
    protected void execute(DummyPayload parameters, ExecutionContext context) throws Exception {
        for (int i = 0; i < multiplicationTasksCount.get(); i++) {
            tasksManager.addMultiplicationTask();
        }

        for (int i = 0; i < loadTasksCount.get(); i++) {
            tasksManager.addLoadTask();
        }

        for (int i = 0; i < sleepTasksCount.get(); i++) {
            tasksManager.addSleepTask();
        }

        for (int i = 0; i < quickMoveTasksCount.get(); i++) {
            tasksManager.addQuickMovePostprocessTask();
        }
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardHours(1);
    }
}
