package ru.yandex.chemodan.app.bazingaload.tasks;

import lombok.AllArgsConstructor;
import lombok.Data;
import org.joda.time.Duration;

import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;


public class QuickMovePostProcessTask extends
        OnetimeTaskSupport<QuickMovePostProcessTask.QuickMovePostProcessParameters>
{

    public QuickMovePostProcessTask() {
        super(QuickMovePostProcessTask.QuickMovePostProcessParameters.class);
    }

    public QuickMovePostProcessTask(QuickMovePostProcessTask.QuickMovePostProcessParameters parameters) {
        super(parameters);
    }

    @Override
    protected void execute(QuickMovePostProcessParameters parameters, ExecutionContext context) throws Exception {
        //to nothing
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardHours(1);
    }

    @BenderBindAllFields
    @AllArgsConstructor
    @Data
    public static class QuickMovePostProcessParameters {
        private final String uid;
        private final String area;
        private final String path;

    }
}
