#!/bin/bash

set -e

ec() {
    echo "$@"
    "$@"
}

unamestr=`uname`

pcp() {
    if [[ $unamestr == 'Darwin' ]]; then
        ec gcp "$@"
    else
        ec cp "$@"
    fi
}

ec cd $(dirname $0)

ARCADIA_ROOT=$(cd ../; pwd)

test -e $ARCADIA_ROOT/disk

YA="devel/ya"

JDK=$(dirname $($YA --no-report tool java --print-path))
PATH="$JDK:/usr/local/lib/jdk1.8.0/bin:/usr/local/jdk1.8.0/bin:$PATH"

ec rm -rf common/lib/runtime
ec rm -rf common/target/

ec rm -rf lib/bin
ec rm -rf disk

ec mkdir -p common/target/classes
ec mkdir -p common/target/jars
ec mkdir -p common/lib/runtime

ec devel/mkversion.sh >common/target/classes/application-version.properties

ec $YA make --checkout
# we must hach this file and rename
ec cp disk.jar common/target/jars/yandex-chemodan.jar
ec rm disk/disk.jar

ec cp disk/*  common/lib/runtime

cd common/target/classes/
ec jar -uf ../../lib/runtime/disk-support-common.jar application-version.properties
cd ../../../
