package ru.yandex.chemodan.app.countersapi;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.countersapi.manager.PublicPageViewsManager;
import ru.yandex.chemodan.app.countersapi.manager.PublicPageViewsManagerImpl;
import ru.yandex.chemodan.boot.DiskAppVersion;
import ru.yandex.misc.version.Version;

/**
 * @author nshmakov
 */
@Configuration
@Import(CassandraContextConfiguration.class)
public class CountersApiContextConfiguration {

    @Bean
    public Version version() {
        return DiskAppVersion.VERSION;
    }

    @Bean
    public PublicPageViewsManager publicPageViewsManager() {
        return new PublicPageViewsManagerImpl();
    }
}
