package ru.yandex.chemodan.app.countersapi;

import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.app.countersapi.web.CountersApiAction;
import ru.yandex.chemodan.app.countersapi.web.CountersApiExceptionHandler;
import ru.yandex.chemodan.app.countersapi.web.GetCounterResultSerializer;
import ru.yandex.chemodan.boot.DiskAppVersion;
import ru.yandex.chemodan.util.web.A3JettyConfiguration;
import ru.yandex.chemodan.util.web.A3JettyContextConfiguration;
import ru.yandex.commune.a3.ActionApp;
import ru.yandex.commune.a3.ActionConfigurator;
import ru.yandex.commune.a3.DefaultActionConfiguration;
import ru.yandex.commune.a3.action.result.ApplicationInfo;
import ru.yandex.commune.a3.action.result.ApplicationResultType;
import ru.yandex.commune.a3.action.result.error.A3ExceptionHandler;
import ru.yandex.commune.a3.action.result.error.AnyExceptionHandler;
import ru.yandex.commune.a3.action.result.type.MediaType;
import ru.yandex.misc.spring.ApplicationContextUtils;
import ru.yandex.misc.version.AppName;

/**
 * @author nshmakov
 */
@Configuration
@Import(A3JettyContextConfiguration.class)
public class CountersApiWebDaemonContextConfiguration {

    @Bean
    public A3JettyConfiguration a3JettyServletsConfiguration() {
        return new A3JettyConfiguration(Tuple2List.fromPairs(
                "/api/*", ""
        ));
    }

    @Bean
    public ActionApp mlrActionApp(
            ApplicationContext context,
            ApplicationInfo applicationInfo)
    {
        ListF<? extends Object> actions = ApplicationContextUtils.beansOfType(context, CountersApiAction.class);
        return ActionConfigurator.configure(
                (ListF<Object>) actions,
                DefaultActionConfiguration.defaultConfiguration(context, applicationInfo)
        );
    }

    @Bean
    public ApplicationInfo applicationInfo(AppName appName, DiskAppVersion appVersion) {
        return new ApplicationInfo(appName.appName(), appVersion.getProjectVersion());
    }

    @Bean
    public ApplicationResultType applicationResultType() {
        return new ApplicationResultType(MediaType.APPLICATION_JSON);
    }

    @Bean
    public GetCounterResultSerializer getCounterResultSerializer() {
        return new GetCounterResultSerializer();
    }

    @Bean
    public AnyExceptionHandler anyExceptionHandler() {
        return new AnyExceptionHandler();
    }

    @Bean
    public A3ExceptionHandler a3ExceptionHandler() {
        return new A3ExceptionHandler();
    }

    @Bean
    public CountersApiExceptionHandler mlrExceptionHandler() {
        return new CountersApiExceptionHandler();
    }
}
