package ru.yandex.chemodan.app.countersapi.manager;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.countersapi.dao.PublicPageViewsDao;

/**
 * @author nshmakov
 */
public class PublicPageViewsManagerImpl implements PublicPageViewsManager {

    @Autowired
    private PublicPageViewsDao publicPageViewsDao;

    @Override
    public MapF<String, Long> getCountersValue(ListF<String> hashes) {
        return publicPageViewsDao.readCounters(hashes);
    }

    @Override
    public void resetCounter(String hash) {
        Option<Long> currentValue = publicPageViewsDao.readCounters(Cf.list(hash)).getO(hash);
        if (!currentValue.isPresent()) {
            throw new CounterNotFoundException("Counter for hash " + hash + " not found");
        }
        publicPageViewsDao.increaseCounter(hash, -currentValue.get());
    }

    public void setPublicPageViewsDao(PublicPageViewsDao publicPageViewsDao) {
        this.publicPageViewsDao = publicPageViewsDao;
    }
}
