package ru.yandex.chemodan.app.countersapi.manager;

import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.countersapi.dao.PublicPageViewsDao;
import ru.yandex.misc.test.Assert;

import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

/**
 * @author nshmakov
 */
public class PublicPageViewsManagerImplTest {

    private PublicPageViewsManagerImpl sut = new PublicPageViewsManagerImpl();

    @Mock
    private PublicPageViewsDao publicPageViewsDaoMock;

    @Before
    public void init() {
        MockitoAnnotations.initMocks(this);
        sut.setPublicPageViewsDao(publicPageViewsDaoMock);
    }

    @Test
    public void shouldGetCounterValue() {
        String hash = "123456";
        MapF<String, Long> expected = Cf.map(hash, 100L);

        when(publicPageViewsDaoMock.readCounters(Cf.list(hash))).thenReturn(expected);
        MapF<String, Long> actual = sut.getCountersValue(Cf.list(hash));

        Assert.equals(expected, actual);
    }

    @Test
    public void shouldResetCounter() {
        String hash = "123456";
        long currentCounterValue = 5;

        when(publicPageViewsDaoMock.readCounters(Cf.list(hash))).thenReturn(Cf.map(hash, currentCounterValue));
        sut.resetCounter(hash);

        verify(publicPageViewsDaoMock).increaseCounter(hash, -currentCounterValue);
    }

    @Test(expected = CounterNotFoundException.class)
    public void shouldThrowCounterNotFoundExceptionForInvalidHash() {
        String invalidHash = "invalid";

        when(publicPageViewsDaoMock.readCounters(Cf.list(invalidHash))).thenReturn(Cf.<String, Long>map());
        sut.resetCounter(invalidHash);
    }
}
