package ru.yandex.chemodan.app.countersapi.web;

import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.junit.Test;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.test.context.ContextConfiguration;

import ru.yandex.chemodan.test.A3TestSupport;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.misc.test.Assert;

/**
 * @author nshmakov
 */
@ContextConfiguration(classes = A3ConfigurationTest.Config.class)
public class A3ConfigurationTest extends A3TestSupport {

    @Test
    public void test404() {
        HttpResponse response = get("/");
        Assert.equals(HttpStatus.SC_NOT_FOUND, response.getStatusLine().getStatusCode());
    }

    @Test
    public void test500() {
        HttpResponse response = get("/api/error");
        Assert.equals(HttpStatus.SC_INTERNAL_SERVER_ERROR, response.getStatusLine().getStatusCode());
    }

    @Configuration
    @Import(A3TestSupportContextConfiguration.class)
    static class Config {

        @Bean
        public ErrorAction errorAction() {
            return new ErrorAction();
        }
    }

    @Path(value = "/error")
    static class ErrorAction implements CountersApiAction {

        @Override
        public Object execute() throws Exception {
            throw new UnsupportedOperationException();
        }
    }
}
