package ru.yandex.chemodan.app.countersapi.web;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.countersapi.CountersApiWebDaemonContextConfiguration;
import ru.yandex.chemodan.boot.ChemodanInitContextConfiguration;
import ru.yandex.commune.a3.action.result.ApplicationInfo;
import ru.yandex.misc.version.AppName;
import ru.yandex.misc.version.SimpleAppName;

/**
 * @author nshmakov
 */
@Configuration
@Import({ CountersApiWebDaemonContextConfiguration.class, ChemodanInitContextConfiguration.class })
public class A3TestSupportContextConfiguration {

    @Bean
    public ApplicationInfo applicationInfo() {
        return ApplicationInfo.UNKNOWN;
    }

    @Bean
    public AppName appName() {
        return new SimpleAppName("disk", "counters-api");
    }
}
