package ru.yandex.chemodan.app.countersapi.web;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.countersapi.manager.CounterNotFoundException;
import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.parameter.WebRequest;
import ru.yandex.commune.a3.action.result.error.ErrorResult;
import ru.yandex.commune.a3.action.result.error.ExceptionHandler;
import ru.yandex.commune.a3.action.result.error.ExceptionHandlerOrders;
import ru.yandex.commune.a3.action.result.error.ExceptionResolver;
import ru.yandex.misc.io.http.HttpStatus;

/**
 * @author nshmakov
 */
public class CountersApiExceptionHandler implements ExceptionHandler {

    @Override
    public Option<?> handleException(WebRequest webRequest, ActionInvocationContext invocationContext,
            ExceptionResolver exceptionResolver, Exception exception)
    {
        if (exception instanceof CounterNotFoundException) {
            invocationContext.getHttpContext().setStatusCode(HttpStatus.SC_404_NOT_FOUND);
            return Option.of(ErrorResult.fromNameAndThrowable(exception.getMessage(), exception));
        }
        return Option.empty();
    }

    @Override
    public int getOrder() {
        return ExceptionHandlerOrders.CUSTOM_EXCEPTION_HANDLER_ORDER;
    }
}
