package ru.yandex.chemodan.app.countersapi.web;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.countersapi.manager.PublicPageViewsManager;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestListParam;

/**
 * @author nshmakov
 */
@Path(value = "/counters", methods = HttpMethod.POST)
public class GetCounterAction implements CountersApiAction {

    @RequestListParam(value = "hashes", ignoreEmpty = true)
    private ListF<String> hashes;

    @Autowired
    private PublicPageViewsManager publicPageViewsManager;

    @Override
    public Object execute() throws Exception {
        return publicPageViewsManager.getCountersValue(hashes);
    }
}
