package ru.yandex.chemodan.app.countersapi.web;

import java.util.Map;

import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.countersapi.manager.PublicPageViewsManager;
import ru.yandex.chemodan.test.A3TestSupport;
import ru.yandex.misc.test.Assert;

import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

/**
 * @author nshmakov
 */
@ContextConfiguration(classes = GetCounterActionTestContextConfiguration.class)
public class GetCounterActionTest extends A3TestSupport {

    @Autowired
    private PublicPageViewsManager publicPageViewsManagerMock;

    @Test
    public void shouldReturnCounterValue() {
        String hash = "123456";
        long expected = 100500;

        when(publicPageViewsManagerMock.getCountersValue(Cf.list(hash))).thenReturn(Cf.map(hash, expected));
        Map<String, Long> actual = postForMapStringLong("/api/counters", Cf.map("hashes", hash));

        Assert.equals(Cf.map(hash, expected), actual);
        verify(publicPageViewsManagerMock).getCountersValue(Cf.list(hash));
    }

    @Test
    public void shouldAcceptSlashesInHash() {
        String hash = "123/456";
        long expected = 100500;

        when(publicPageViewsManagerMock.getCountersValue(Cf.list(hash))).thenReturn(Cf.map(hash, expected));
        Map<String, Long> actual = postForMapStringLong("/api/counters", Cf.map("hashes", hash));

        Assert.equals(Cf.map(hash, expected), actual);
        verify(publicPageViewsManagerMock).getCountersValue(Cf.list(hash));
    }

    @Test
    public void shouldAcceptMultipleHashes() {
        ListF<String> hashes = Cf.list("123", "456");
        ListF<Long> hashesValue = Cf.list(100L, 500L);
        MapF<String, Long> expected = hashes.zip(hashesValue).toMap();

        when(publicPageViewsManagerMock.getCountersValue(hashes)).thenReturn(expected);
        Map<String, Long> actual = postForMapStringLong("/api/counters", Cf.map("hashes", hashes.mkString(",")));

        Assert.equals(expected, actual);
        verify(publicPageViewsManagerMock).getCountersValue(hashes);
    }

    @Test
    public void shouldReturnEmptyResultWhenNoHashesFound() {
        ListF<String> hashes = Cf.list("123", "456", "678");

        when(publicPageViewsManagerMock.getCountersValue(hashes)).thenReturn(Cf.<String, Long>map());
        Map<String, Long> actual = postForMapStringLong("/api/counters", Cf.map("hashes", hashes.mkString(",")));

        Assert.isEmpty(actual);
        verify(publicPageViewsManagerMock).getCountersValue(hashes);
    }

    @Test
    public void shouldReturn400ForEmptyHashes() {
        HttpResponse response = post("/api/counters", Cf.map("hashes", ""));
        Assert.equals(HttpStatus.SC_BAD_REQUEST, response.getStatusLine().getStatusCode());
    }
}
