package ru.yandex.chemodan.app.countersapi.web;

import java.io.OutputStream;
import java.util.Map;

import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.result.AbstractResultSerializer;
import ru.yandex.commune.a3.action.result.type.MediaType;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.bender.serialize.BenderXmlOrJsonWriter;

/**
 * @author nshmakov
 */
public class GetCounterResultSerializer extends AbstractResultSerializer<Map<String, Long>> {

    @Override
    protected void serializeSafely(Map<String, Long> result, ActionInvocationContext context, OutputStream stream) throws Exception {
        BenderJsonWriter json = BenderXmlOrJsonWriter.json(stream).getJson();

        json.writeObjectStart();
        for (Map.Entry<String, Long> entry : result.entrySet()) {
            json.writeFieldName(entry.getKey());
            json.writeNumber(entry.getValue());
        }
        json.writeObjectEnd();

        json.flush();
    }

    @Override
    protected boolean supports(Object result) {
        return result instanceof Map;
    }

    @Override
    protected MediaType getContentType() {
        return MediaType.APPLICATION_JSON;
    }
}
