package ru.yandex.chemodan.app.countersapi.web;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.app.countersapi.manager.PublicPageViewsManager;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.a3.action.result.NoContent;

/**
 * @author nshmakov
 */
@Path(value = "/counters/reset", methods = HttpMethod.POST)
public class ResetCounterAction implements CountersApiAction {

    @RequestParam(value = "hash", ignoreEmpty = true)
    private String hash;

    @Autowired
    private PublicPageViewsManager publicPageViewsManager;

    @Override
    public Object execute() throws Exception {
        publicPageViewsManager.resetCounter(hash);
        return NoContent.cons();
    }
}
