package ru.yandex.chemodan.app.countersapi.web;

import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

import ru.yandex.chemodan.app.countersapi.manager.CounterNotFoundException;
import ru.yandex.chemodan.app.countersapi.manager.PublicPageViewsManager;
import ru.yandex.chemodan.test.A3TestSupport;
import ru.yandex.misc.test.Assert;

import static org.mockito.Mockito.doThrow;
import static org.mockito.Mockito.verify;

/**
 * @author nshmakov
 */
@ContextConfiguration(classes = ResetCounterActionTestContextConfiguration.class)
public class ResetCounterActionTest extends A3TestSupport {

    @Autowired
    private PublicPageViewsManager publicPageViewsManagerMock;

    @Test
    public void shouldResetCounter() {
        String hash = "123456";

        HttpResponse response = post("/api/counters/reset?hash=" + hash);

        Assert.equals(HttpStatus.SC_NO_CONTENT, response.getStatusLine().getStatusCode());
        verify(publicPageViewsManagerMock).resetCounter(hash);
    }

    @Test
    public void shouldReturn404ForInvalidHash() {
        String invalidHash = "invalid";

        doThrow(CounterNotFoundException.class).when(publicPageViewsManagerMock).resetCounter(invalidHash);
        HttpResponse response = post("/api/counters/reset?hash=" + invalidHash);

        Assert.equals(HttpStatus.SC_NOT_FOUND, response.getStatusLine().getStatusCode());
    }

    @Test
    public void shouldReturn400ForEmptyHash() {
        HttpResponse response = post("/api/counters/reset?hash=");
        Assert.equals(HttpStatus.SC_BAD_REQUEST, response.getStatusLine().getStatusCode());
    }
}
