<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:z="urn:zscript-functions">

    <xsl:import href="admin://common.xsl"/>

    <xsl:variable name="uid" select="/page/content/uid"/>
    <xsl:variable name="text" select="/page/content/text"/>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="error"/>
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <div id="main-content">
            <div class="container">
                <form method="GET">
                    <table border="0">
                        <tr>
                            <td>UID: </td>
                            <td><input name="uid"><xsl:attribute name="value" select="$uid"/></input></td>
                            <td><input name="text"><xsl:attribute name="value" select="$text"/></input></td>
                            <td>
                                <button class="btn btn-primary" type="submit">Find</button>
                            </td>
                        </tr>
                    </table>
                </form>
                <table width="100%">
                    <xsl:for-each select="rows">
                        <tr>
                            <xsl:for-each select="items">
                                <td width="20%">
                                    <img src="{preview-url}" border="1" width="200px"/>
                                    <xsl:value-of select="distance"/>
                                </td>
                            </xsl:for-each>
                        </tr>
                    </xsl:for-each>
                </table>
            </div>
        </div>
    </xsl:template>

</xsl:stylesheet>
