package ru.yandex.chemodan.app.cvdemo.admin;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.app.cvdemo.core.CvSignaturesManager;
import ru.yandex.chemodan.mpfs.MpfsFileInfo;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.admin.z.ZAction;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.bender.annotation.XmlRootElement;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author tolmalev
 */
@ActionContainer
public class CvSearchAdminPage {
    private final CvSignaturesManager cvSignaturesManager;

    public CvSearchAdminPage(CvSignaturesManager cvSignaturesManager) {
        this.cvSignaturesManager = cvSignaturesManager;
    }

    @ZAction(defaultAction = true, file = "cv_search.xsl")
    @Path("/cv-search")
    public CvSearchResultsPojo cvSearch(
            @RequestParam(value = "uid", required = false)
            String uid,
            @RequestParam(value = "text", required = false)
            String text)
    {
        uid = StringUtils.defaultIfEmpty(uid, "").trim();
        text = StringUtils.defaultIfEmpty(text, "").trim();

        if ("".equals(uid) || "".equals(text)) {
            return new CvSearchResultsPojo(uid, text, Cf.list());
        }

        Tuple2List<MpfsFileInfo, Double> results = cvSignaturesManager.findByCv(uid, text, 100);

        ListF<CvSearchResultRow> rows = Cf.arrayList();
        ListF<CvSearchResultPojo> current = null;
        for (Tuple2<MpfsFileInfo, Double> result : results) {
            if (current == null) {
                current = Cf.arrayList();
                rows.add(new CvSearchResultRow(current));
            }
            current.add(new CvSearchResultPojo(result._1.meta.customPreview.get(), result._2));
            if (current.size() >= 5) {
                current = null;
            }
        }

        return new CvSearchResultsPojo(uid, text, rows);
    }

    @Bendable
    @XmlRootElement(name = "content")
    @BenderMembersToBind(MembersToBind.ALL_FIELDS)
    private static class CvSearchResultsPojo {
        public final String uid;
        public final String text;
        public final ListF<CvSearchResultRow> rows;

        private CvSearchResultsPojo(String uid, String text, ListF<CvSearchResultRow> rows) {
            this.uid = uid;
            this.text = text;
            this.rows = rows;
        }
    }

    @BenderBindAllFields
    private static class CvSearchResultRow {
        public final ListF<CvSearchResultPojo> items;

        private CvSearchResultRow(ListF<CvSearchResultPojo> items) {
            this.items = items;
        }
    }

    @BenderBindAllFields
    private static class CvSearchResultPojo {
        public final String previewUrl;
        public final double distance;

        private CvSearchResultPojo(String previewUrl, double distance) {
            this.previewUrl = previewUrl;
            this.distance = distance;
        }
    }
}
