package ru.yandex.chemodan.app.cvdemo.core;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.cvdemo.core.dao.CvDataSourceContextConfiguration;
import ru.yandex.chemodan.app.cvdemo.core.dao.CvJdbcContextConfiguration;
import ru.yandex.chemodan.app.cvdemo.core.dao.CvSignaturesDao;
import ru.yandex.chemodan.app.cvdemo.core.imageparser.Imageparser;
import ru.yandex.chemodan.app.cvdemo.core.imageparser.TextProcessor;
import ru.yandex.chemodan.mpfs.MpfsClient;
import ru.yandex.chemodan.mulca.MulcaClientContextConfiguration;
import ru.yandex.commune.bazinga.BazingaTaskManager;
import ru.yandex.inside.mulca.MulcaClient;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

/**
 * @author tolmalev
 */
@Configuration
@Import({
        CvDataSourceContextConfiguration.class,
        MulcaClientContextConfiguration.class,
        CvJdbcContextConfiguration.class
})
public class CvSignaturesCoreContextConfiguration {
    @Bean
    public CvSignaturesManager cvSignaturesManager(CvSignaturesDao dao, MpfsClient mpfsClient,
            BazingaTaskManager bazingaTaskManager, MulcaClient mulcaClient, Imageparser imageparser,
            TextProcessor textProcessor)
    {
        return new CvSignaturesManager(dao, mpfsClient, bazingaTaskManager, imageparser, textProcessor, mulcaClient);
    }

    @Bean
    public CvSignaturesDao cvSignaturesDao(
            @Qualifier("cvBaseJdbcTemplate")
            JdbcTemplate3 baseJdbcTemplate)
    {
        return new CvSignaturesDao(baseJdbcTemplate);
    }

    @Bean
    public Imageparser imageparser(
            @Value("${cv.imageparser.config.path}")
            String imageparserConfigPath)
    {
        return new Imageparser(imageparserConfigPath);
    }

    @Bean
    public TextProcessor textProcessor(
            @Value("${cv.dssm.config.path}")
            String dssmConfigPath)
    {
        return new TextProcessor(dssmConfigPath);
    }

    @Bean
    public CvVideoCreator cvVideoCreator() {
        return null;
    }
}
