package ru.yandex.chemodan.app.cvdemo.core;

import java.util.List;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.mpfs.MpfsClient;
import ru.yandex.chemodan.mpfs.MpfsFileInfo;
import ru.yandex.chemodan.mpfs.MpfsUid;
import ru.yandex.chemodan.mpfs.lentablock.MpfsLentaBlockFullDescription;
import ru.yandex.chemodan.mpfs.lentablock.MpfsLentaBlockItemDescription;
import ru.yandex.chemodan.util.TimeUtils;
import ru.yandex.inside.mulca.MulcaClient;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.lang.Validate;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author tolmalev
 */
public class CvVideoCreator {
    private static final Logger logger = LoggerFactory.getLogger(CvVideoCreator.class);

    private final DiskSearchClient searchClient;
    private final MpfsClient mpfsClient;
    private final MulcaClient mulcaClient;

    public CvVideoCreator(MpfsClient mpfsClient, MulcaClient mulcaClient) {
        this.mpfsClient = mpfsClient;
        this.mulcaClient = mulcaClient;
    }

    public boolean selectForVideo(String uid, Instant start, Instant end) {
        String resourceId = mpfsClient
                .getFileInfoByUidAndPath(uid, "/disk/Фотокамера")
                .meta
                .resourceId
                .get()
                .serialize();

        Option<MpfsLentaBlockFullDescription> lentaBlockO =
                mpfsClient.getLentaBlockFilesData(new PassportUid(Long.parseLong(uid)),
                        resourceId,
                        "image",
                        new MpfsUid(uid),
                        TimeUtils.unixTime(start),
                        TimeUtils.unixTimeTill(end),
                        10000,
                        "");

        if(!lentaBlockO.isPresent()) {
            logger.debug("No files found: {}", uid, start, end);
            return false;
        }

        MpfsLentaBlockFullDescription block = lentaBlockO.get();

        ListF<MpfsLentaBlockItemDescription> sortedResources = block.files
                .filter(i -> i.etime.isPresent())
                .filter(i -> i.preview.isPresent())
                .sortedBy(info -> info.etime.get());

        ListF<MpfsLentaBlockItemDescription> data = Cf.arrayList();
        if (sortedResources.isEmpty()) {
            return false;
        }

        if (data.size() < 50) {
            return false;
        }

        ListF<MpfsLentaBlockItemDescription> filtered = filterList(data, i -> i.etime.get(), 20);

        ListF<String> resourceIds = filtered.map(i -> i.resourceId);
        ListF<MpfsFileInfo> fileInfos = mpfsClient.bulkInfoByResourceIds(uid, resourceIds);

        for (MpfsFileInfo info : fileInfos) {
            File2 path = new File2("/Users/tolmalev/Downloads/tmp").child(info.name.get());

            mulcaClient
                    .download(MulcaId.fromSerializedString(info.meta.pmid.get()))
                    .readTo(path);

            logger.debug("Downloaded file into: {}", path.getAbsolutePath());
        }
        return true;
    }

    public static <T> ListF<T> filterList(List<T> list, Function<T, Long> fn, int amount) {
        Validate.ge(amount, 2);

        if (list.size() <= amount) {
            return Cf.toList(list);
        }

        ListF<T> tmp = Cf.toArrayList(list);
        ListF<Long> pos = Cf.toArrayList(tmp.map(fn));
        ListF<Long> distances = Cf.arrayList();

        for (int i = 0; i < tmp.size() - 1; i++) {
            distances.add(pos.get(i + 1) - pos.get(i));
        }

        while (tmp.size() > amount) {
            long minDistance = distances.get(0);
            int minIndex = 0;

            //find min distance
            for (int i = 0; i < distances.size(); i++) {
                if (minDistance > distances.get(i)) {
                    minIndex = i;
                    minDistance = distances.get(i);
                }
            }

            if (minIndex == 0) {
                minIndex += 1;
            }

            tmp.remove(minIndex);
            pos.remove(minIndex);
            distances.remove(minIndex);

            if (minIndex != 0) {
                distances.set(minIndex - 1, pos.get(minIndex) - pos.get(minIndex - 1));
            }
        }

        return tmp;
    }
}
