package ru.yandex.chemodan.app.cvdemo.core.dao;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.jdbc.DataSourceProperties;
import ru.yandex.misc.db.embedded.ConditionalOnMissingEmbeddedDb;

/**
 * @author tolmalev
 */
@Configuration
@ConditionalOnMissingEmbeddedDb
public class CvDataSourceContextConfiguration {

    @Bean
    @OverridableValuePrefix("cv")
    public DataSourceProperties cvDataSourceProperties() {
        return new DataSourceProperties();
    }
}
