package ru.yandex.chemodan.app.cvdemo.core.dao;

import javax.sql.DataSource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.util.jdbc.DataSourceProperties;
import ru.yandex.chemodan.util.jdbc.JdbcDatabaseConfigurator;
import ru.yandex.chemodan.util.jdbc.JdbcDatabaseConfiguratorContextConfiguration;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

/**
 * @author tolmalev
 */
@Configuration
@Import({
        JdbcDatabaseConfiguratorContextConfiguration.class,
        CvDataSourceContextConfiguration.class
})
public class CvJdbcContextConfiguration {

    @Autowired
    private JdbcDatabaseConfiguratorContextConfiguration dbConfiguratorConfig;

    @Bean
    public JdbcDatabaseConfigurator cvDbConfigurator(DataSourceProperties cvDataSourceProperties) {
        return dbConfiguratorConfig.consJdbcConfigurator(cvDataSourceProperties);
    }

    @Bean
    public DataSource cvDataSource(
            @Qualifier("cvDbConfigurator")
            JdbcDatabaseConfigurator dbConfigurator)
    {
        return dbConfigurator.configureDataSource();
    }

    @Bean
    public JdbcTemplate3 cvBaseJdbcTemplate(
            @Qualifier("cvDbConfigurator")
            JdbcDatabaseConfigurator dbConfigurator,
            @Qualifier("cvDataSource")
            DataSource cvDataSource)
    {
        return dbConfigurator.consTemplate(cvDataSource);
    }
}
