package ru.yandex.chemodan.app.cvdemo.core.dao;

import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.cvdemo.core.imageparser.FloatListUtils;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

/*


 */

/**
 * @author tolmalev
 */
public class CvSignaturesDao {

    private final JdbcTemplate3 jdbcTemplate;

    public CvSignaturesDao(JdbcTemplate3 jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public void dropAllForUser(String uid) {
        jdbcTemplate.update("DELETE FROM cv_signatures WHERE uid = ?", uid);
    }

    public boolean userHasCv(String uid) {
        String q = "SELECT uid from cv_signatures where uid = ? LIMIT 1";

        return jdbcTemplate.queryForList(q, String.class, uid).size() > 0;
    }

    public void insertOrUpdateSignature(String uid, String resourceId, long version, Float[] signature) {
        String q = "INSERT INTO cv_signatures AS cv (uid, resource_id, ver, signature)\n"
                + "    VALUES (?, ?, ?, cube(?))\n"
                + "ON CONFLICT (uid, resource_id) DO UPDATE SET\n"
                + "  ver = EXCLUDED.ver, signature = EXCLUDED.signature\n"
                + "WHERE cv.ver < EXCLUDED.ver";

        jdbcTemplate.update(q, new PreparedStatementSetter() {
            @Override
            public void setValues(PreparedStatement ps) throws SQLException {
                Array arr = ps.getConnection().createArrayOf("float", signature);

                ps.setString(1, uid);
                ps.setString(2, resourceId);
                ps.setLong(3, version);
                ps.setArray(4, arr);
            }
        });
    }

    public ListF<CvSignatureSearchResult> findNearest(String uid, Float[] signature, int limit) {
        String q = "SELECT uid, resource_id, signature, signature <-> cube(?) as dist FROM cv_signatures "
                + "WHERE uid = ? "
                + "ORDER BY dist "
                + "LIMIT ?";

        return jdbcTemplate.query(q, new PreparedStatementSetter() {
            @Override
            public void setValues(PreparedStatement ps) throws SQLException {
                Array arr = ps.getConnection().createArrayOf("float", signature);

                ps.setArray(1, arr);
                ps.setString(2, uid);
                ps.setInt(3, limit);
            }
        }, new RowMapper<CvSignatureSearchResult>() {
            @Override
            public CvSignatureSearchResult mapRow(ResultSet rs, int rowNum) throws SQLException {
                return new CvSignatureSearchResult(
                        rs.getString("uid"),
                        rs.getString("resource_id"),
                        FloatListUtils.parseStrWithBraces(rs.getString("signature")),
                        rs.getDouble("dist"));
            }
        });
    }

    public static class CvSignatureSearchResult {
        public final String uid;
        public final String resourceId;
        public final Float[] signature;

        public final double distance;

        public CvSignatureSearchResult(String uid, String resourceId, Float[] signature, double distance) {
            this.uid = uid;
            this.resourceId = resourceId;
            this.signature = signature;
            this.distance = distance;
        }
    }
}
