package ru.yandex.chemodan.app.cvdemo.core.imageparser;

import java.nio.file.Paths;

import ru.yandex.chemodan.util.json.JsonNodeUtils;
import ru.yandex.function.Processor;
import ru.yandex.jniwrapper.ImmutableJniWrapperConfig;
import ru.yandex.jniwrapper.JniWrapper;
import ru.yandex.jniwrapper.JniWrapperConfigBuilder;
import ru.yandex.jniwrapper.JniWrapperException;
import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.parser.config.IniConfig;

/**
 * @author tolmalev
 */
public class Imageparser {
    private static final Logger logger = LoggerFactory.getLogger(Imageparser.class);

    private final String imageparserConfigPath;

    public Imageparser(String imageparserConfigPath) {
        this.imageparserConfigPath = imageparserConfigPath;
    }

    public Float[] getSignature(byte[] imageBytes) {
        try {
            logger.debug("Start getting signature");

            Processor<byte[], String, JniWrapperException> processor =
                    JniWrapper.create(
                            new ImmutableJniWrapperConfig(
                                    new JniWrapperConfigBuilder(
                                            new IniConfig(Paths.get(imageparserConfigPath)))))
                            .apply("", null);

            String jsonResult = processor.process(imageBytes);
            String floatListStr = JsonNodeUtils.getNode(jsonResult).get("i2t").asText();

            logger.debug("Got signature: {}", floatListStr);

            return FloatListUtils.parseStr(floatListStr);
        } catch (Exception e) {
            throw ExceptionUtils.translate(e);
        }
    }
}
