package ru.yandex.chemodan.app.cvdemo.core.imageparser;

import java.nio.file.Paths;

import ru.yandex.jniwrapper.ImmutableJniWrapperConfig;
import ru.yandex.jniwrapper.JniWrapper;
import ru.yandex.jniwrapper.JniWrapperConfigBuilder;
import ru.yandex.jniwrapper.JniWrapperException;
import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.parser.config.IniConfig;

/**
 * @author tolmalev
 */
public class TextProcessor {
    private static final Logger logger = LoggerFactory.getLogger(TextProcessor.class);

    private final String dssmConfigPath;
    private JniWrapper jniWrapper = null;

    public TextProcessor(String dssmConfigPath) {
        this.dssmConfigPath = dssmConfigPath;
    }

    public synchronized Float[] convertText(String text) {
        if (jniWrapper == null) {
            start();
        }
        try {
            String floatListStr = jniWrapper.apply(text, null).process(new byte[]{});
            return FloatListUtils.parseStr(floatListStr);
        } catch (JniWrapperException e) {
            throw ExceptionUtils.translate(e);
        }
    }

    public void start() {
        logger.debug("Loading text network");
        try {
            jniWrapper = JniWrapper.create(
                    new ImmutableJniWrapperConfig(
                            new JniWrapperConfigBuilder(
                                    new IniConfig(Paths.get(dssmConfigPath)))));
        } catch (Exception e) {
            throw ExceptionUtils.translate(e);
        }
        logger.debug("Loaded text network");
    }
}
