package ru.yandex.chemodan.app.cvdemo.worker;

import org.joda.time.Duration;

import ru.yandex.chemodan.app.cvdemo.core.CvSignaturesManager;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author tolmalev
 */
public class CalculateImageSignatureTask extends OnetimeTaskSupport<CalculateImageSignatureTask.Parameters> {

    private final CvSignaturesManager manager;

    public CalculateImageSignatureTask(String uid, String resourceId) {
        super(new Parameters(uid, resourceId));
        manager = null;
    }

    public CalculateImageSignatureTask(CvSignaturesManager manager) {
        super(Parameters.class);
        this.manager = manager;
    }

    @Override
    protected void execute(Parameters parameters, ExecutionContext context) throws Exception {
        manager.recalculateSignatureAndStore(parameters.uid, parameters.resourceId);
    }

    @Override
    public TaskQueueName queueName() {
        return CvDemoTaskQueueName.CV_DEMO_CPU_INTENSIVE;
    }

    @Override
    public int priority() {
        return 10;
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(2);
    }

    @BenderBindAllFields
    public static class Parameters {
        public final String uid;
        public final String resourceId;

        public Parameters(String uid, String resourceId) {
            this.uid = uid;
            this.resourceId = resourceId;
        }
    }
}
