package ru.yandex.chemodan.app.cvdemo.worker;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.cvdemo.core.CvSignaturesManager;
import ru.yandex.chemodan.bazinga.BazingaWorkerTaskQueues;
import ru.yandex.chemodan.bazinga.ChemodanBazingaWorkerContextConfiguration;
import ru.yandex.chemodan.mpfs.MpfsClient;
import ru.yandex.commune.bazinga.pg.worker.PgBazingaWorkerConfiguration;
import ru.yandex.inside.mulca.MulcaClient;

/**
 * @author tolmalev
 */
@Configuration
@Import({
        ChemodanBazingaWorkerContextConfiguration.class
})
public class CvDemoWorkerContextConfiguration {
    @Bean
    public PgBazingaWorkerConfiguration pgBazingaWorkerConfiguration() {
        return new PgBazingaWorkerConfiguration(Cf.list(CvDemoTaskQueueName.CV_DEMO_CRON));
    }

    @Bean
    public BazingaWorkerTaskQueues taskQueues(
            @Value("${lenta-worker.set-memories-blocks.tasks.count}")
                    int setMemoriesBlocksCount,
            @Value("${lenta-worker.set-memories-blocks.tasks.queue}")
                    int setMemoriesBlocksQueue)
    {
        return new BazingaWorkerTaskQueues(
                Option.of(CvDemoTaskQueueName.CV_DEMO_CRON),
                Option.of(CvDemoTaskQueueName.CV_DEMO_REGULAR),
                Option.of(CvDemoTaskQueueName.CV_DEMO_CPU_INTENSIVE),
                Cf.list());
    }

    @Bean
    public ReindexUserCvTask reindexUserTask(CvSignaturesManager manager) {
        return new ReindexUserCvTask(manager);
    }

    @Bean
    public GenerateGifAnimationTask generateGifAnimationTask(
            CvSignaturesManager manager,
            MpfsClient mpfsClient,
            MulcaClient mulcaClient)
    {
        return new GenerateGifAnimationTask(manager, mpfsClient, mulcaClient);
    }

//    @Bean
//    public CalculateImageSignatureTask calculateImageSignatureTask(CvSignaturesManager manager) {
//        return new CalculateImageSignatureTask(manager);
//    }
//
//    @Bean
//    public CalculateImageSignatureHighPriorityTask calculateImageSignatureHighPriorityTask(CvSignaturesManager manager)
//    {
//        return new CalculateImageSignatureHighPriorityTask(manager);
//    }
}
