package ru.yandex.chemodan.app.cvdemo2.admin;

import java.util.List;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author tolmalev
 */
public class BaseGridGenerator {

    public static class BaseGridGeneratorConfig extends DefaultObject {
        public final int columns;
        public final int maxPhotosInBaseGrid;
        public final MapF<String, int[][]> allowedSizesByType;

        public BaseGridGeneratorConfig(int columns, int maxPhotosInBaseGrid, MapF<String, int[][]> allowedSizesByType) {
            this.columns = columns;
            this.maxPhotosInBaseGrid = maxPhotosInBaseGrid;
            this.allowedSizesByType = allowedSizesByType;
        }

        @Override
        public String toString() {
            return
                    "columns=" + columns
                    + ", maxPhotosInBaseGrid=" + maxPhotosInBaseGrid
                    + ", allowedSizesByType = {"
                    + allowedSizesByType.entries().map2(i -> Cf.x(i).map(j -> j[0] + "x" + j[1]).sorted().mkString("|")).sortedBy1().mkString(",")
                    + "}";
        }
    }

    public MapF<String, List<GridGenerator.BaseGrid>> generateBaseGrids(BaseGridGeneratorConfig config) {
        return generateBaseGrids(config.columns, config.maxPhotosInBaseGrid, config.allowedSizesByType);
    }

    public MapF<String, List<GridGenerator.BaseGrid>> generateBaseGrids(int columns, int maxPhotosInBaseGrid,
                                                                        MapF<String, int[][]> allowedSizesByType)
    {
        MapF<String, List<GridGenerator.BaseGrid>> result = Cf.hashMap();
        int[][] grid = new int[columns * 50][columns];

        for (int i = 1; i <= maxPhotosInBaseGrid; i++) {
            generateBaseGrids(result, allowedSizesByType, new Grid(), grid, i);
        }
        return result;
    }

    private void generateBaseGrids(MapF<String, List<GridGenerator.BaseGrid>> result,
                                   MapF<String, int[][]> allowedSizesByType,
                                   Grid cur,
                                   int[][] grid,
                                   int maxCount)
    {
        if (maxCount == 0) {
            boolean gridIsBad = false;
            int gridLines = 0;
            for (int i = 0; i < grid.length; i++) {
                boolean fullFilled = true;
                boolean fullZero = true;
                boolean allNotSameAsPrev = i != 0;

                for (int j = 0; j < grid[i].length; j++) {
                    if (i > 0 && grid[i][j] == grid[i - 1][j]) {
                        allNotSameAsPrev = false;
                    }

                    if (grid[i][j] == 0) {
                        fullFilled = false;
                    } else {
                        fullZero = false;
                    }
                }
                if (!fullZero && allNotSameAsPrev) {
                    gridIsBad = true;
                    break;
                }
                if (!fullFilled && !fullZero) {
                    gridIsBad = true;
                    break;
                }
                if (fullZero) {
                    gridIsBad = false;
                    gridLines = i;
                    break;
                }
            }

            if (!gridIsBad && cur.positions.size() > 7) {
                for (char c : cur.name.toCharArray()) {
                    if (c == 's' || c == '-') {
                        gridIsBad = true;
                        break;
                    }
                }
            }

            if (!gridIsBad) {
                List<GridGenerator.BaseGrid> grids = result.getOrElseUpdate(cur.name, Cf.arrayList());
                GridGenerator.BaseGrid baseGrid = new GridGenerator.BaseGrid(cur.positions.map(i -> i));
                grids.add(baseGrid);
            }
            return;
        }

        int startI = -1, startJ = -1;
        for (int i = 0; startI < 0 && i < grid.length; i++) {
            for (int j = 0; startI < 0 && j < grid[i].length; j++) {
                if (grid[i][j] == 0) {
                    startI = i;
                    startJ = j;
                }
            }
        }

        for (String type : allowedSizesByType.keySet()) {
            for (int[] sizes : allowedSizesByType.getTs(type)) {
                int w = sizes[0];
                int h = sizes[1];

                if (startJ + w <= grid[0].length) {
                    boolean goodPlace = true;
                    for (int i = 0; goodPlace && i < h; i++) {
                        for (int j = 0; goodPlace && j < w; j++) {
                            if (grid[startI + i][startJ + j] != 0) {
                                goodPlace = false;
                            }
                        }
                    }
                    if (!goodPlace) {
                        continue;
                    }

                    for (int i = 0; goodPlace && i < h; i++) {
                        for (int j = 0; goodPlace && j < w; j++) {
                            grid[startI + i][startJ + j] = maxCount;
                        }
                    }

                    cur.name += type;
                    cur.positions.add(new GridGenerator.PhotoPosition(startJ, startI, w, h));
                    generateBaseGrids(result, allowedSizesByType, cur, grid, maxCount - 1);

                    cur.name = cur.name.substring(0, cur.name.length() - 1);
                    cur.positions.remove(cur.positions.size() - 1);

                    for (int i = 0; goodPlace && i < h; i++) {
                        for (int j = 0; goodPlace && j < w; j++) {
                            grid[startI + i][startJ + j] = 0;
                        }
                    }
                }
            }
        }
    }

    static class Grid {
        String name;
        ListF<GridGenerator.PhotoPosition> positions;

        public Grid(String name, List<GridGenerator.PhotoPosition> positions) {
            this.name = name;
            this.positions = Cf.x(positions);
        }

        public Grid() {
            this.name = "";
            this.positions = Cf.arrayList();
        }
    }
}
