package ru.yandex.chemodan.app.cvdemo2.admin;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;

/**
 * @author tolmalev
 */
public class BaseGridGeneratorTest {
    @Test
    public void generateBase() throws IOException {
        MapF<String, int[][]> mobileAllowedByType = Cf.hashMap();
        mobileAllowedByType.put("h", new int[][] {
                {2, 2},
                {3, 3},
                {4, 4},
                {5, 5},
                {6, 6},
//                {10,10},
//                {12,12},
//                {14,14}
        });

        mobileAllowedByType.put("s", new int[][] {
                {2, 3},
                {4, 6},
        });

        mobileAllowedByType.put("v", new int[][] {
                {2, 4},
                {3, 5},
//                {4, 6},
                {4, 8},
//                {6, 10},
//                {10,16},
//                {12,18},
//                {14,20}
        });

        mobileAllowedByType.put("-", new int[][] {
                {4,2},
                {6,3},
                {8,4},
//                {10,5},
//                {12,6},
//                {14,7}
        });

        int columns = 14;
        int photos = 9;

        if (columns == 14) {
            mobileAllowedByType.put("h", new int[][] {
                    {2, 2},
                    {3, 3},
                    {4, 4},
                    {5, 5},
                    {6, 6},
                    {7, 7},
            });

            mobileAllowedByType.put("s", new int[][] {
                    {2, 3},
                    {4, 6},
                    {6, 9},
            });
        }

        MapF<String, List<GridGenerator.BaseGrid>> baseGrids = new BaseGridGenerator().generateBaseGrids(columns, photos, mobileAllowedByType);

        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JsonGenerator js = new JsonFactory().createJsonGenerator(baos);

        js.writeStartObject();

//        System.out.println("MapF<String, List<GridGenerator.BaseGrid>> baseGrids = Cf.hashMap()");
        for (String key : baseGrids.keySet()) {
            js.writeFieldName(key);
            js.writeStartArray();

            for (GridGenerator.BaseGrid baseGrid : baseGrids.getTs(key)) {
                js.writeStartArray();
                baseGrid.positions.forEach(pos -> {
                    try {
                        js.writeStartArray();

                        js.writeNumber(pos.x);

                        js.writeNumber(pos.y);

                        js.writeNumber(pos.w);

                        js.writeNumber(pos.h);

                        js.writeEndArray();
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                });
                js.writeEndArray();
            }

            js.writeEndArray();
//            break;
//            System.out.println("baseGrids.put(\"" + key + "\", new ArrayList<>());");
//            for (GridGenerator.BaseGrid baseGrid : baseGrids.getTs(key)) {
//                String listCreation = "Cf.list(" + Cf.x(baseGrid.positions).map(pos -> {
//                    return "new GridGenerator.PhotoPosition(" + pos.x + "," + pos.y +"," + pos.w + "," + pos.w + ")";
//                }).mkString(",") + ")";
//                System.out.println("baseGrids.get(\"" + key + "\").add(new GridGenerator.BaseGrid(" + listCreation + "));");
//            }
        }

        js.writeEndObject();
        js.flush();
        System.out.println(new String(baos.toByteArray()));

//        File2 file2 = new File2("/Users/tolmalev/Downloads/grid_" + columns + "_" + photos + ".json");
//        file2.write(baos.toByteArray());
    }

    @Test
    public void checkPossibleGrids() {

        MapF<String, int[][]> mobileAllowedByType = Cf.hashMap();
        mobileAllowedByType.put("h", new int[][] {
                {2, 2},
                {3, 3},
                {4, 4},
                {5, 5},
                {6, 6},
        });

        mobileAllowedByType.put("s", new int[][] {
                {2, 3},
                {4, 6},
        });

        mobileAllowedByType.put("v", new int[][] {
                {2, 4},
                {3, 5},
                {4, 8},
                {5, 10},
        });

        mobileAllowedByType.put("-", new int[][] {
                {4,2},
                {6,3},
                {8,4},
        });

        MapF<String, List<GridGenerator.BaseGrid>> baseGrids = new BaseGridGenerator().generateBaseGrids(12, 9, mobileAllowedByType);
        GridGenerator.GridGeneratorConfig config = new GridGenerator.GridGeneratorConfig(baseGrids, 1, 5, 5, 5, 5, 5, 5);
        GridGenerator gridGenerator = new GridGenerator(config);

        int good = 0;
        int bad = 0;

        for (int i = 2 * 2 * 2; i < 2 * 2 * 2 * 2 * 2 * 2; i++) {
            List<GridGenerator.PhotoInfo> photos = Cf.arrayList();
            String line = "";

            int ii = i;
            while (ii > 0) {
                switch (ii % 2) {
                    case 0:
                        line += "h";
                        photos.add(0, new GridGenerator.PhotoInfo(300, 200, Option.empty()));
                        break;
                    case 1:
                        line += "v";
                        photos.add(0, new GridGenerator.PhotoInfo(200, 300, Option.empty()));
                        break;
                    case 2:
                        line += "s";
                        photos.add(0, new GridGenerator.PhotoInfo(300, 300, Option.empty()));
                        break;
                    case 3:
                        line += "-";
                        photos.add(0, new GridGenerator.PhotoInfo(300, 10, Option.empty()));
                        break;
                }
                ii /= 2;
            }

            GridGenerator.Grid grid = gridGenerator.generateGrid(photos);
            if (grid == null) {
                System.out.println("No grid: " + line);
                bad++;
            } else {
                good++;
//                System.out.println("Good grid: " + line);
            }
        }

        System.out.println("good grids: " + good);
        System.out.println("bad grids: " + bad);
    }
}
