package ru.yandex.chemodan.app.cvdemo2.admin;

import java.lang.reflect.Field;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.lentaloader.reminder.Cvi2tProcessor;
import ru.yandex.chemodan.app.lentaloader.reminder.DiskSearchClient;
import ru.yandex.chemodan.mpfs.MpfsClient;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.chemodan.zk.registries.staff.YandexStaffUserRegistry;
import ru.yandex.chemodan.zk.registries.staff.YandexStaffUserRegistryContextConfiguration;
import ru.yandex.commune.admin.web.AdminApp;
import ru.yandex.commune.admin.web.AdminMenuLink;
import ru.yandex.commune.admin.web.AdminMenuManager;

/**
 * @author tolmalev
 */
@Configuration
@Import({
        YandexStaffUserRegistryContextConfiguration.class
})
public class CvAdminContextConfiguration {

    @Autowired
    private AdminApp adminApp;
    @Value("${cv.public.export:-false}")
    private boolean isPublic;

//    @Bean
//    public CvBeautyAdminPage cvSearchAdminPage(CvBeautyManager manager, YandexStaffUserRegistry staffRegistry) {
//        CvBeautyAdminPage page = new CvBeautyAdminPage(manager, staffRegistry, isPublic);
//        adminApp.registerAdminPage(page);
//        return page;
//    }

    @Bean
    public CvGridAdminPage cvGridAdminPage(DiskSearchClient diskSearchClient, MpfsClient mpfsClient) {
        CvGridAdminPage page = new CvGridAdminPage(diskSearchClient, mpfsClient);
        adminApp.registerAdminPage(page);
        return page;
    }

    @Bean
    public CvGridAdminPage2 cvGridAdminPage2(DiskSearchClient diskSearchClient, MpfsClient mpfsClient, YandexStaffUserRegistry staffRegistry) {
        CvGridAdminPage2 page = new CvGridAdminPage2(diskSearchClient, mpfsClient, staffRegistry);
        adminApp.registerAdminPage(page);
        return page;
    }

    @Bean
    public CvSelectorAdminPage cvSelectorAdminPage(Cvi2tProcessor cvi2tProcessor,
                                                   YandexStaffUserRegistry staffRegistry, DiskSearchClient diskSearchClient, MpfsClient mpfsClient)
    {
        CvSelectorAdminPage page = new CvSelectorAdminPage(staffRegistry, diskSearchClient, mpfsClient, cvi2tProcessor);
        adminApp.registerAdminPage(page);
        return page;
    }

    @Bean
    public SimilarityCvSelectorAdminPage similarityCvSelectorAdminPage(YandexStaffUserRegistry staffRegistry,
            DiskSearchClient diskSearchClient, MpfsClient mpfsClient)
    {
        SimilarityCvSelectorAdminPage page = new SimilarityCvSelectorAdminPage(staffRegistry, diskSearchClient,
                mpfsClient);
        adminApp.registerAdminPage(page);
        return page;
    }

    @Bean
    public CvDocumentsAdminPage cvDocumentsAdminPage(YandexStaffUserRegistry staffRegistry,
            HttpClientConfigurator searchHttpClientConfigurator,
            @Value("${search.clusterizer.url}") String searchUrl,
            MpfsClient mpfsClient)
    {
        CvDocumentsAdminPage page = new CvDocumentsAdminPage(staffRegistry, searchHttpClientConfigurator.configure(), searchUrl, mpfsClient);
        adminApp.registerAdminPage(page);
        return page;
    }

    @PostConstruct
    public void cleanMenu() {
        if (!isPublic) {
            return;
        }

        try {
            Field adminMenuManagerField = AdminApp.class.getDeclaredField("adminMenuManager");
            adminMenuManagerField.setAccessible(true);
            AdminMenuManager adminMenuManager = (AdminMenuManager) adminMenuManagerField.get(adminApp);
            Field linksField = AdminMenuManager.class.getDeclaredField("links");
            linksField.setAccessible(true);
            ListF<AdminMenuLink> links = (ListF<AdminMenuLink>) linksField.get(adminMenuManager);
            Cf.toList(links);
            links.removeAllTs(links.filter(l -> !l.getTitle().equals("Cv Beauty")));
        } catch (NoSuchFieldException | IllegalAccessException ignore) {
        }
    }

}
