<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:z="urn:zscript-functions">

    <xsl:import href="admin://common.xsl"/>

    <xsl:variable name="uid" select="/page/content/uid"/>
    <xsl:variable name="from" select="/page/content/from"/>
    <xsl:variable name="to" select="/page/content/to"/>
    <xsl:variable name="limit" select="/page/content/limit"/>
    <xsl:variable name="metricExpression" select="/page/content/metric-expression"/>
    <xsl:variable name="groupTime" select="/page/content/group-time"/>
    <xsl:variable name="orderType" select="/page/content/order-type"/>

    <xsl:template match="page" mode="additional-script">
        <script type="text/javascript" src="/z/r/cv-beauty/collapse.js"/>
        <script type="text/javascript" src="/z/r/cv-beauty/moment-with-locales.min.js"/>
        <script type="text/javascript" src="/z/r/cv-beauty/transition.js"/>
        <script type="text/javascript" src="/z/r/cv-beauty/bootstrap-datetimepicker.min.js"/>
        <script type="text/javascript" src="/z/r/cv-beauty/CvBeautyAdminPage-cv_beauty.js"/>

        <script src="https://yastatic.net/react/15.5.4/react-with-addons.min.js" crossorigin="anonymous"/>
        <script src="https://yastatic.net/react/15.5.4/react-dom.min.js" crossorigin="anonymous"/>

        <script type="application/json" id="data">
            <xsl:value-of select="/page/content/app-json"/>
        </script>
        <script type="application/javascript" src="/z/r/cv-beauty/CvBeautyAdminPage-bundle.js"/>
    </xsl:template>

    <xsl:template match="page" mode="head-extra">
        <link rel="stylesheet" type="text/css" href="/z/r/cv-beauty/CvBeautyAdminPage-bundle.css"/>
        <link rel="stylesheet" type="text/css" href="/z/r/cv-beauty/bootstrap-datetimepicker.min.css"/>
    </xsl:template>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="error"/>
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <div id="main-content">
            <div class="container">
                <form method="GET" class="form-inline" width="100%">
                    <input name="uid" type="hidden" value="{$uid}"/>
                    <input name="groupTime" type="hidden" value="{$groupTime}"/>
                    <input name="limit" type="hidden" value="{$limit}"/>
                    <input name="orderType" type="hidden" value="{$orderType}"/>

                    <div class="form-group">
                        <label for="date_from" style="margin-right:5px">От: </label>
                        <div class='input-group date' id='date_from'>
                            <input name="from" type='text' class="form-control" value="{$from}"/>
                            <span class="input-group-addon">
                                <span class="glyphicon glyphicon-calendar"></span>
                            </span>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="date_to" style="margin-right:5px">До: </label>
                        <div class='input-group date' id='date_to'>
                            <input name="to" type='text' class="form-control"  value="{$to}"/>
                            <span class="input-group-addon">
                                <span class="glyphicon glyphicon-calendar"></span>
                            </span>
                        </div>
                    </div>
                    <button class="btn btn-primary" type="submit" style="margin-left:5px">Сделать красиво!</button>
                </form>
                <hr/>
                <h2>Лучшие отобранные в порядке съемки</h2>
                <div id="app"/>
                <hr/>
                <h2>Топ-200 из диапазона по убыванию "красивости"</h2>
                <table width="100%">
                    <xsl:for-each select="all">
                        <tr>
                            <xsl:for-each select="items">
                                <td width="20%">
                                    <a href="{big-preview-url}" target="_blank" >
                                        <img src="{preview-url}" border="1" width="200px"/>
                                    </a>
                                    <xsl:value-of select="metric-value"/>
                                </td>
                            </xsl:for-each>
                        </tr>
                    </xsl:for-each>
                </table>
            </div>
        </div>
    </xsl:template>

</xsl:stylesheet>
