<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:z="urn:zscript-functions">

    <xsl:import href="admin://common.xsl"/>

    <xsl:variable name="uid" select="/page/content/uid"/>
    <xsl:variable name="from" select="/page/content/from"/>
    <xsl:variable name="to" select="/page/content/to"/>
    <xsl:variable name="limit" select="/page/content/limit"/>
    <xsl:variable name="metricExpression" select="/page/content/metric-expression"/>
    <xsl:variable name="groupTime" select="/page/content/group-time"/>
    <xsl:variable name="orderType" select="/page/content/order-type"/>

    <xsl:template match="page" mode="additional-script">
        <script type="text/javascript" src="/z/r/cv-beauty/collapse.js"/>
        <script type="text/javascript" src="/z/r/cv-beauty/moment-with-locales.min.js"/>
        <script type="text/javascript" src="/z/r/cv-beauty/transition.js"/>
        <script type="text/javascript" src="/z/r/cv-beauty/bootstrap-datetimepicker.min.js"/>

        <script src="https://yastatic.net/react/15.5.4/react-with-addons.min.js" crossorigin="anonymous"/>
        <script src="https://yastatic.net/react/15.5.4/react-dom.min.js" crossorigin="anonymous"/>

        <script type="application/json" id="data">
            <xsl:value-of select="/page/content/app-json"/>
        </script>
    </xsl:template>

    <xsl:template match="page" mode="head-extra">
        <link rel="stylesheet" type="text/css" href="/z/r/cv-beauty/CvBeautyAdminPage-bundle.css"/>
        <link rel="stylesheet" type="text/css" href="/z/r/cv-beauty/bootstrap-datetimepicker.min.css"/>
    </xsl:template>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="error"/>
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <div id="main-content">
            <div class="container">
                <xsl:for-each select="grids">
                    <xsl:for-each select="images">
                        <div style="position:absolute;width:{w}px;height:{h}px;left:{x}px;top:{y}px;border-color:white;border-width:3px;border-style:solid;">
                            <a href="{substring-before(preview-link, 'size=')}size=XXXL&amp;crop=1">
                                <img border="1" width="100%" height="100%" src="{substring-before(preview-link, 'size=')}size={w}x{h}&amp;crop=1"/>
                            </a>
                        </div>
                    </xsl:for-each>
                </xsl:for-each>
            </div>
        </div>
    </xsl:template>

</xsl:stylesheet>
