package ru.yandex.chemodan.app.cvdemo2.admin;

import lombok.Data;
import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.app.lentaloader.reminder.DiskSearchClient;
import ru.yandex.chemodan.app.lentaloader.reminder.DiskSearchFileInfo;
import ru.yandex.chemodan.mpfs.MpfsClient;
import ru.yandex.chemodan.mpfs.MpfsFileInfo;
import ru.yandex.chemodan.mpfs.MpfsUser;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.admin.z.ZAction;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.XmlRootElement;
import ru.yandex.misc.lang.Check;
import ru.yandex.misc.random.Random2;
import ru.yandex.misc.time.InstantInterval;

/**
 * @author tolmalev
 */
@ActionContainer
public class CvGridAdminPage {
    public int globalN = 0;

    private final DiskSearchClient diskSearchClient;
    private final MpfsClient mpfsClient;

    public CvGridAdminPage(DiskSearchClient diskSearchClient, MpfsClient mpfsClient) {
        this.diskSearchClient = diskSearchClient;
        this.mpfsClient = mpfsClient;
    }

    @ZAction(defaultAction = true, file = "cv_grid.xsl")
    @Path("/cv-grid")
    public CvGridsPojo cvBeautySearch(
            @RequestParam(value = "count", required = false) Option<Integer> count,
            @RequestParam(value = "monthsAgo", required = false) Option<Integer> monthsAgo,
            @RequestParam(value = "uid", required = false) Option<String> suid
    ) {
        PassportUid uid = PassportUid.cons(Cf.Long.parse(suid.getOrElse("50273844")));
        InstantInterval interval = new InstantInterval(Instant.now().minus(Duration.standardDays(30 * monthsAgo.getOrElse(1))), Instant.now());

        ListF<DiskSearchFileInfo> searchInfos =Random2.R.randomElements(diskSearchClient
                .findPhotosWithBeauty(uid, interval, Option.empty(), 0, 10000).hitsArray
                        .filter(sfi -> sfi.width.isPresent() && sfi.height.isPresent()), 100);

        ListF<String> resourceIds = searchInfos.map(item -> uid.toString() + ":" + item.getId());
        ListF<MpfsFileInfo> files = Random2.R.randomElements(mpfsClient.bulkInfoByResourceIds(MpfsUser.of(uid), resourceIds,
                Cf.list("/disk", "/photounlim")), count.getOrElse(10));

        int minY = 100;
        int gridCols = 6;
        int gridRows = (int) Math.ceil(3 * files.size() * 1.0 / gridCols);

        MapF<String, DiskSearchFileInfo> fiByResourceId = searchInfos.toMapMappingToKey(item -> uid.toString() + ":" + item.getId());

        Tuple2List<Integer, Integer> fileSizes = files.toTuple2List(f -> {
            DiskSearchFileInfo fi = fiByResourceId.getTs(f.getMeta().getResourceId().get().toString());
            return Tuple2.tuple(fi.width.get(), fi.height.get());
        });

        int[][] baseGrid = generateGrid(gridCols, gridRows, fileSizes);

        int gridCellW = 60 * 3;
        int gridCellH = 60 * 3 * 2 / 3;

        CvGridPojo webGrid = new CvGridPojo(files.zipWithIndex().map((info, i) -> {
            int minI = 1000, minJ = 1000, maxI = -1, maxJ = -1;
            for (int k = 0; k < baseGrid.length; k++) {
                for (int t = 0; t < baseGrid[0].length; t++) {
                    if (baseGrid[k][t] == i + 1) {
                        minI = Math.min(minI, k);
                        minJ = Math.min(minJ, t);
                        maxI = Math.max(maxI, k);
                        maxJ = Math.max(maxJ, t);
                    }
                }
            }

            //minI - by y
            //minJ - by x

            return new OneImageGridPojo(
                    gridCellW * minJ,
                    minY + gridCellH * minI,
                    (maxJ - minJ + 1) * gridCellW,
                    (maxI - minI + 1) * gridCellH,
                    info.getMeta().getPreview().get(),
                    info.getMeta().getFileUrl().get()
            );
        }));


        int minX = (gridCols + 1) * gridCellW;
        gridCols = 3;
        gridRows = (int) Math.ceil(4 * files.size() * 1.0 / gridCols);
        int[][] baseGrid2 = generateGrid(gridCols, gridRows, fileSizes);

        int gridCellW2 = 60 * 2;
        int gridCellH2 = 60 * 2 * 2 / 3;

        CvGridPojo mobileGrid = new CvGridPojo(files.zipWithIndex().map((info, i) -> {
            int minI = 1000, minJ = 1000, maxI = -1, maxJ = -1;
            for (int k = 0; k < baseGrid2.length; k++) {
                for (int t = 0; t < baseGrid2[0].length; t++) {
                    if (baseGrid2[k][t] == i + 1) {
                        minI = Math.min(minI, k);
                        minJ = Math.min(minJ, t);
                        maxI = Math.max(maxI, k);
                        maxJ = Math.max(maxJ, t);
                    }
                }
            }

            //minI - by y
            //minJ - by x

            return new OneImageGridPojo(
                    minX + gridCellW2 * minJ,
                    minY + gridCellH2 * minI,
                    (maxJ - minJ + 1) * gridCellW2,
                    (maxI - minI + 1) * gridCellH2,
                    info.getMeta().getPreview().get(),
                    info.getMeta().getFileUrl().get()
            );
        }));



        return new CvGridsPojo(Cf.list(webGrid, mobileGrid));
    }

    int[][] generateGrid(int gridCols, int gridRows, Tuple2List<Integer, Integer> sizes) {
        int[][] grid = new int[gridRows][gridCols];

        boolean geenrated = tryContinueGrid(grid, 1, sizes);
        Check.isTrue(geenrated, "Failed to generate grid");

        return grid;
    }

    private boolean tryContinueGrid(int[][] grid, int currentPhoto, Tuple2List<Integer, Integer> sizes) {
        globalN++;
        int N = grid.length;
        int M = grid[0].length;

        if (currentPhoto > sizes.size()) {
            for (int i = 0; i < N; i++) {
                for (int j = 0; j < M; j++) {
                    if (grid[i][j] == 0) {
                        return false;
                    }
                }
            }
            return true;
        }

        int firstI = -1;
        int firstJ = -1;
        for (int i = 0; i < N; i++) {
            for (int j = 0; j < M; j++) {
                if (grid[i][j] == 0) {
                    firstI = i;
                    firstJ = j;
                    break;
                }
            }
            if (firstI != -1) {
                break;
            }
        }
        if (firstI == -1 || firstJ == -1) {
            return false;
        }

        int averageCellsSize = (int) Math.round(N * M * 1.0 / sizes.size());

        ListF<Integer> deltas = Cf.range(-10, 11).shuffle();
//        ListF<Integer> deltas = Cf.range(-3, 4).shuffle();
        int photoWidth = sizes.get(currentPhoto - 1)._1;
        int photoHeight = sizes.get(currentPhoto - 1)._2;

        double aspect = photoWidth * 1.0 / photoHeight;

        for (int d : deltas) {
            int imageSize = averageCellsSize + d;
            if (imageSize <= 0) {
                continue;
            }

            for (int w : Cf.range(1, imageSize + 1).shuffle()) {
                if (imageSize % w != 0) {
                    continue;
                }
                int h = imageSize / w;

                double currentAspect = h * 1.0 / w;
                if (aspect < 1 && currentAspect > 1) {
                    continue;
                }
                if (aspect > 1 && currentAspect < 1) {
                    continue;
                }
                if (Math.abs(currentAspect - aspect) / aspect > 0.5) {
                    continue;
                }

                if (firstI + w <= N && firstJ + h <= M) {
                    boolean canBePlaced = true;
                    for (int ii = firstI; canBePlaced && ii < firstI + w; ii++) {
                        for (int jj = firstJ; canBePlaced && jj < firstJ + h; jj++) {
                            if (grid[ii][jj] != 0) {
                                canBePlaced = false;
                            }
                        }
                    }
                    if (!canBePlaced) {
                        continue;
                    }
                    for (int ii = firstI; ii < firstI + w; ii++) {
                        for (int jj = firstJ; jj < firstJ + h; jj++) {
                            grid[ii][jj] = currentPhoto;
                        }
                    }
                    if (tryContinueGrid(grid, currentPhoto + 1, sizes)) {
                        return true;
                    }
                    for (int ii = firstI; ii < firstI + w; ii++) {
                        for (int jj = firstJ; jj < firstJ + h; jj++) {
                            grid[ii][jj] = 0;
                        }
                    }
                }
            }
        }
        return false;
    }

    @Data
    @BenderBindAllFields
    @XmlRootElement(name = "content")
    static class CvGridsPojo {
        public final ListF<CvGridPojo> grids;
    }

    @Data
    @BenderBindAllFields
    @XmlRootElement(name = "content")
    static class CvGridPojo {
        public final ListF<OneImageGridPojo> images;
    }

    @Data
    @BenderBindAllFields
    static class OneImageGridPojo {
        public final int x;
        public final int y;
        public final int w;
        public final int h;
        public final String previewLink;
        public final String originalLink;
    }
}
