<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:z="urn:zscript-functions">

    <!--<xsl:import href="admin://common.xsl"/>-->

    <xsl:variable name="uid" select="/page/content/uid"/>
    <xsl:variable name="count" select="/page/content/count"/>
    <xsl:variable name="daysAgoStart" select="/page/content/days-ago-start"/>
    <xsl:variable name="daysAgoEnd" select="/page/content/days-ago-end"/>

    <xsl:variable name="normalPhotoSize" select="/page/content/normal-photo-size"/>
    <xsl:variable name="normalSizeK" select="/page/content/normal-size-k"/>
    <xsl:variable name="beautyK" select="/page/content/beauty-k"/>
    <xsl:variable name="cropK" select="/page/content/crop-k"/>
    <xsl:variable name="sizeDiffK" select="/page/content/size-diff-k"/>
    <xsl:variable name="photosInBlockK" select="/page/content/photos-in-block-k"/>
    <xsl:variable name="singlePhotoK" select="/page/content/single-photo-k"/>

    <xsl:variable name="onlyVertical" select="/page/content/only-vertical"/>
    <xsl:variable name="onlyHorizontal" select="/page/content/only-horizontal"/>

    <xsl:variable name="cellWidth" select="/page/content/cell-width"/>
    <xsl:variable name="columns" select="/page/content/columns"/>
    <xsl:variable name="maxPhotosInBlock" select="/page/content/max-photos-in-block"/>
    <xsl:variable name="verticalSizes" select="/page/content/vertical-sizes"/>
    <xsl:variable name="horizontalSizes" select="/page/content/horizontal-sizes"/>
    <xsl:variable name="panoramaSizes" select="/page/content/panorama-sizes"/>
    <xsl:variable name="squareSizes" select="/page/content/square-sizes"/>

    <!--<xsl:template match="page" mode="additional-script">-->
        <!--<script type="text/javascript" src="/z/r/cv-beauty/collapse.js"/>-->
        <!--<script type="text/javascript" src="/z/r/cv-beauty/moment-with-locales.min.js"/>-->
        <!--<script type="text/javascript" src="/z/r/cv-beauty/transition.js"/>-->
        <!--<script type="text/javascript" src="/z/r/cv-beauty/bootstrap-datetimepicker.min.js"/>-->

        <!--<script src="https://yastatic.net/react/15.5.4/react-with-addons.min.js" crossorigin="anonymous"/>-->
        <!--<script src="https://yastatic.net/react/15.5.4/react-dom.min.js" crossorigin="anonymous"/>-->

        <!--<script type="application/json" id="data">-->
            <!--<xsl:value-of select="/page/content/app-json"/>-->
        <!--</script>-->
    <!--</xsl:template>-->

    <!--<xsl:template match="page" mode="head-extra">-->
        <!--<link rel="stylesheet" type="text/css" href="/z/r/cv-beauty/CvBeautyAdminPage-bundle.css"/>-->
        <!--<link rel="stylesheet" type="text/css" href="/z/r/cv-beauty/bootstrap-datetimepicker.min.css"/>-->
    <!--</xsl:template>-->

    <!--<xsl:template match="page" mode="content">-->
    <xsl:template match="page">
        <xsl:apply-templates select="error"/>
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <div id="main-content">
            <form method="GET" class="form-inline" width="100%">
                <input name="uid" type="hidden" value="{$uid}"/>
                <table>
                    <tr>
                        <td>
                            Начало интервала (дней назад):
                        </td>
                        <td>
                            <input name="daysAgoStart" type='text' class="form-control" value="{$daysAgoStart}"/>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            Конец интервала (дней назад)
                        </td>
                        <td>
                            <input name="daysAgoEnd" type='text' class="form-control"  value="{$daysAgoEnd}"/>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            Число фотографий
                        </td>
                        <td>
                            <input name="count" type='text' class="form-control"  value="{$count}"/>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            Нормальный размер фото
                        </td>
                        <td>
                            <input name="normalPhotoSize" type='text' class="form-control"  value="{$normalPhotoSize}"/>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            normalSizeK
                        </td>
                        <td>
                            <input name="normalSizeK" type='text' class="form-control"  value="{$normalSizeK}"/>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            beautyK
                        </td>
                        <td>
                            <input name="beautyK" type='text' class="form-control"  value="{$beautyK}"/>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            sizeDiffK
                        </td>
                        <td>
                            <input name="sizeDiffK" type='text' class="form-control"  value="{$sizeDiffK}"/>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            photosInBlockK
                        </td>
                        <td>
                            <input name="photosInBlockK" type='text' class="form-control"  value="{$photosInBlockK}"/>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            singlePhotoK
                        </td>
                        <td>
                            <input name="singlePhotoK" type='text' class="form-control"  value="{$singlePhotoK}"/>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            Только вертикальные
                        </td>
                        <td>
                            <input name="onlyVertical" type='checkbox' class="form-control"  value="true">
                                <xsl:if test="$onlyVertical = 'true'">
                                    <xsl:attribute name="checked"/>
                                </xsl:if>
                            </input>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            Только горизонтальные
                        </td>
                        <td>
                            <input name="onlyHorizontal" type='checkbox' class="form-control" value="true">
                                <xsl:if test="$onlyHorizontal = 'true'">
                                    <xsl:attribute name="checked"/>
                                </xsl:if>
                            </input>
                        </td>
                    </tr>
                </table>
                <br/>
                cellWidth: <input name="cellW" type='text' class="form-control"  value="{$cellWidth}"/><br/>
                columns: <input name="gridColumns" type='text' class="form-control"  value="{$columns}"/><br/>
                maxPhotosInBlock: <input name="maxPhotosInBlock" type='text' class="form-control"  value="{$maxPhotosInBlock}"/><br/>

                v: <input name="verticalSizes" type='text' class="form-control"  value="{$verticalSizes}"/><br/>
                h: <input name="horizontalSizes" type='text' class="form-control"  value="{$horizontalSizes}"/><br/>
                -: <input name="panoramaSizes" type='text' class="form-control"  value="{$panoramaSizes}"/><br/>
                s: <input name="squareSizes" type='text' class="form-control"  value="{$squareSizes}"/><br/>

                <button class="btn btn-primary" type="submit" style="margin-left:5px">Сделать красиво!</button>
            </form>
            <div class="container">
                <xsl:for-each select="grids">
                    <xsl:for-each select="images">
                        <xsl:variable name="border" select="1"/>
                        <div style="position:absolute;width:{w - $border * 2}px;height:{h - $border * 2}px;left:{x}px;top:{y}px;">
                            <a href="{substring-before(preview-link, 'size=')}size=XXXL&amp;crop=1">
                                <img style="border-color:white;border-width:{$border}px;border-style:solid;" border="1" width="100%" height="100%" src="{substring-before(preview-link, 'size=')}size={w}x{h}&amp;crop=1"/>
                            </a>
                        </div>
                    </xsl:for-each>
                </xsl:for-each>
            </div>
        </div>
    </xsl:template>

</xsl:stylesheet>
