<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:z="urn:zscript-functions">

    <xsl:import href="admin://common.xsl"/>

    <xsl:variable name="text" select="/page/content/text"/>

    <xsl:variable name="uid" select="/page/content/uid"/>
    <xsl:variable name="from" select="/page/content/from"/>
    <xsl:variable name="to" select="/page/content/to"/>
    <xsl:variable name="limit" select="/page/content/limit"/>

    <xsl:variable name="new_beauty-limit" select="/page/content/new-beauty-limit"/>
    <xsl:variable name="max_beauty" select="/page/content/max-beauty"/>
    <xsl:variable name="match-limit" select="/page/content/match-limit"/>
    <xsl:variable name="sort-by-time" select="/page/content/sort_by_time"/>

    <xsl:template match="page" mode="additional-script">
        <script type="text/javascript" src="/z/r/cv-beauty/collapse.js"/>
        <script type="text/javascript" src="/z/r/cv-beauty/moment-with-locales.min.js"/>
        <script type="text/javascript" src="/z/r/cv-beauty/transition.js"/>
        <script type="text/javascript" src="/z/r/cv-beauty/bootstrap-datetimepicker.min.js"/>
        <script type="text/javascript" src="/z/r/cv-beauty/CvSelectorAdminPage-cv_selector.js"/>

        <script src="https://yastatic.net/react/15.5.4/react-with-addons.min.js" crossorigin="anonymous"/>
        <script src="https://yastatic.net/react/15.5.4/react-dom.min.js" crossorigin="anonymous"/>
    </xsl:template>

    <xsl:template match="page" mode="head-extra">
        <link rel="stylesheet" type="text/css" href="/z/r/cv-beauty/CvBeautyAdminPage-bundle.css"/>
        <link rel="stylesheet" type="text/css" href="/z/r/cv-beauty/bootstrap-datetimepicker.min.css"/>
    </xsl:template>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="error"/>
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <div id="main-content">
            <div class="container">
                <form method="GET" class="form-inline" width="100%">
                    <input name="uid" type="hidden" value="{$uid}"/>
                    <input name="limit" type="hidden" value="{$limit}"/>
                    <input name="matchLimit" type="hidden" value="{$match-limit}"/>
                    <input name="maxBeauty" type="hidden" value="{$max_beauty}"/>
                    <input name="sortByTime" type="hidden" value="{$sort-by-time}"/>

                    <div class="form-group">
                        <label for="text" style="margin-right:5px">Текст: </label>
                        <div class='input-group text' id='text'>
                            <input name="text" type='text' class="form-control" value="{$text}"/>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="date_from" style="margin-right:5px">От: </label>
                        <div class='input-group date' id='date_from'>
                            <input name="from" type='text' class="form-control" value="{$from}"/>
                            <span class="input-group-addon">
                                <span class="glyphicon glyphicon-calendar"></span>
                            </span>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="date_to" style="margin-right:5px">До: </label>
                        <div class='input-group date' id='date_to'>
                            <input name="to" type='text' class="form-control"  value="{$to}"/>
                            <span class="input-group-addon">
                                <span class="glyphicon glyphicon-calendar"></span>
                            </span>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="newBeautyLimit" style="margin-right:5px">Красивость: </label>
                        <div class='input-group date' id='date_to'>
                            <input name="newBeautyLimit" type='text' class="form-control"  value="{$new_beauty-limit}"/>
                        </div>
                    </div>
                    <button class="btn btn-primary" type="submit" style="margin-left:5px">Выбрать</button>
                </form>
                <hr/>

                <table>
                    <xsl:for-each select="rows">
                        <tr>
                            <xsl:for-each select="photos">
                                <td>
                                    <xsl:value-of select="match"/>
                                    <xsl:text> / </xsl:text>
                                    <xsl:value-of select="new-beauty"/>
                                    <br/>
                                    <a href="{original-link}" target="_blank" >
                                        <img src="{preview-link}&amp;size=200x200&amp;crop=1" border="1"/>
                                    </a>
                                </td>
                            </xsl:for-each>
                        </tr>
                    </xsl:for-each>
                </table>
            </div>
        </div>
    </xsl:template>

</xsl:stylesheet>
