<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:z="urn:zscript-functions">

    <xsl:import href="admin://common.xsl"/>

    <xsl:variable name="uid" select="/page/content/uid"/>
    <xsl:variable name="from" select="/page/content/from"/>
    <xsl:variable name="to" select="/page/content/to"/>
    <xsl:variable name="limit" select="/page/content/limit"/>
    <xsl:variable name="match-limit" select="/page/content/match-limit"/>
    <xsl:variable name="bucket-limit" select="/page/content/bucket-limit"/>

    <xsl:template match="page" mode="additional-script">
        <script type="text/javascript" src="/z/r/cv-beauty/collapse.js"/>
        <script type="text/javascript" src="/z/r/cv-beauty/moment-with-locales.min.js"/>
        <script type="text/javascript" src="/z/r/cv-beauty/transition.js"/>
        <script type="text/javascript" src="/z/r/cv-beauty/bootstrap-datetimepicker.min.js"/>
        <script type="text/javascript" src="/z/r/cv-beauty/CvSelectorAdminPage-cv_selector.js"/>

        <script src="https://yastatic.net/react/15.5.4/react-with-addons.min.js" crossorigin="anonymous"/>
        <script src="https://yastatic.net/react/15.5.4/react-dom.min.js" crossorigin="anonymous"/>
    </xsl:template>

    <xsl:template match="page" mode="head-extra">
        <link rel="stylesheet" type="text/css" href="/z/r/cv-beauty/CvBeautyAdminPage-bundle.css"/>
        <link rel="stylesheet" type="text/css" href="/z/r/cv-beauty/bootstrap-datetimepicker.min.css"/>
    </xsl:template>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="error"/>
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <div id="main-content">
            <div class="container">
                <form method="GET" class="form-inline" width="100%">
                    <input name="uid" type="hidden" value="{$uid}"/>

                    <div class="form-group">
                        <label for="text" style="margin-right:5px">Граница похожести: </label>
                        <div class='input-group text' id='match_limit'>
                            <input name="matchLimit" type='text' class="form-control" value="{$match-limit}"/>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="text" style="margin-right:5px">Количество подборок: </label>
                        <div class='input-group text' id='limit'>
                            <input name="limit" type='text' class="form-control" value="{$limit}"/>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="text" style="margin-right:5px">Количество фоток в подборке: </label>
                        <div class='input-group text' id='similarity_bucket_limit'>
                            <input name="similarityBucketLimit" type='text' class="form-control" value="{$bucket-limit}"/>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="date_from" style="margin-right:5px">От: </label>
                        <div class='input-group date' id='date_from'>
                            <input name="from" type='text' class="form-control" value="{$from}"/>
                            <span class="input-group-addon">
                                <span class="glyphicon glyphicon-calendar"></span>
                            </span>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="date_to" style="margin-right:5px">До: </label>
                        <div class='input-group date' id='date_to'>
                            <input name="to" type='text' class="form-control"  value="{$to}"/>
                            <span class="input-group-addon">
                                <span class="glyphicon glyphicon-calendar"></span>
                            </span>
                        </div>
                    </div>
                    <button class="btn btn-primary" type="submit" style="margin-left:5px">Выбрать</button>
                </form>
                <hr/>

                <table>
                    <xsl:for-each select="rows">
                        <tr>
                            <td>
                                <xsl:text>Исходник: </xsl:text>
                                <br/>
                                <a href="{source-photo/original-link}" target="_blank" >
                                    <img src="{source-photo/preview-link}&amp;size=200x200&amp;crop=1" border="1"/>
                                </a>
                            </td>
                            <xsl:for-each select="photos">
                                <td>
                                    <xsl:value-of select="match"/>
                                    <br/>
                                    <a href="{original-link}" target="_blank" >
                                        <img src="{preview-link}&amp;size=200x200&amp;crop=1" border="1"/>
                                    </a>
                                </td>
                            </xsl:for-each>
                        </tr>
                    </xsl:for-each>
                </table>
            </div>
        </div>
    </xsl:template>

</xsl:stylesheet>
