package ru.yandex.chemodan.app.cvdemo2.core;


import java.io.IOException;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ByteArrayEntity;

import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.misc.io.InputStreamSourceUtils;
import ru.yandex.misc.io.http.apache.v4.Abstract200ExtendedResponseHandler;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;

/**
 * @author tolmalev
 */
public class CvApiClient {
    public final DynamicProperty<String> cvParamsStr =
            new DynamicProperty<>("cvdemo2-cv-params", "RunNeuralNetClassifier");

    private final String baseUrl;
    private final HttpClient httpClient;

    public CvApiClient(String baseUrl, HttpClient httpClient) {
        this.baseUrl = baseUrl;
        this.httpClient = httpClient;
    }

    public String getCvJsonData(byte[] imageData) {
        String uri = baseUrl + "?" + cvParamsStr.get();

        HttpPost post = new HttpPost(uri);
        post.setEntity(new ByteArrayEntity(imageData));

        return ApacheHttpClientUtils.execute(post, new Abstract200ExtendedResponseHandler<String>() {
            @Override
            protected String handle200Response(HttpResponse response) throws IOException {
                HttpEntity entity = response.getEntity();
                if (entity == null) {
                    return "";
                }
                return InputStreamSourceUtils.wrap(entity.getContent()).readText("utf-8");
            }
        });
    }
}
