package ru.yandex.chemodan.app.cvdemo2.core;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.cvdemo2.core.dao.CvBeautyDao;
import ru.yandex.chemodan.app.cvdemo2.core.dao.CvDataSourceContextConfiguration;
import ru.yandex.chemodan.app.cvdemo2.core.dao.CvJdbcContextConfiguration;
import ru.yandex.chemodan.app.lentaloader.reminder.DiskSearchClient;
import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.mpfs.MpfsClient;
import ru.yandex.chemodan.mulca.MulcaClientContextConfiguration;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.commune.bazinga.BazingaTaskManager;
import ru.yandex.inside.mulca.MulcaClient;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

/**
 * @author tolmalev
 */
@Configuration
@Import({
        CvDataSourceContextConfiguration.class,
        MulcaClientContextConfiguration.class,
        CvJdbcContextConfiguration.class
})
public class CvBeautyCoreContextConfiguration {
    @Bean
    public CvBeautyManager cvBeautyManager(CvBeautyDao dao, MpfsClient mpfsClient,
            BazingaTaskManager bazingaTaskManager, MulcaClient mulcaClient,
            DiskSearchClient searchClient,
            CvApiClient cvApiClient)
    {
        return new CvBeautyManager(dao, mpfsClient, bazingaTaskManager, mulcaClient, searchClient, cvApiClient);
    }

    @Bean
    public CvApiClient cvApiClient(@Value("${cv.api.url}") String cvBaseUrl) {
        return new CvApiClient(cvBaseUrl, cvHttpClientConfigurator().configure());
    }

    @Bean
    @OverridableValuePrefix("cv")
    public HttpClientConfigurator cvHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }

    @Bean
    public CvBeautyDao cvSignaturesDao(
            @Qualifier("cvBaseJdbcTemplate")
            JdbcTemplate3 baseJdbcTemplate)
    {
        return new CvBeautyDao(baseJdbcTemplate);
    }
}
