package ru.yandex.chemodan.app.cvdemo2.core.dao;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.db.q.SqlLimits;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

/**
 * @author tolmalev
 */
public class CvBeautyDao {

    private final JdbcTemplate3 jdbcTemplate;

    public CvBeautyDao(JdbcTemplate3 jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public void dropAllForUser(String uid) {
        jdbcTemplate.update("DELETE FROM cv_beauty WHERE uid = ?", uid);
    }

    public void insertOrUpdateCvData(String uid, String resourceId, Instant etime, long version, String jsonData) {
        String q = "INSERT INTO cv_beauty AS cv (uid, resource_id, etime, version, data)\n"
                + "    VALUES (?, ?, ?, ?, ?)\n"
                + "ON CONFLICT (uid, resource_id) DO UPDATE SET\n"
                + "  version = EXCLUDED.version, data = EXCLUDED.data\n"
                + "WHERE cv.version < EXCLUDED.version";

        jdbcTemplate.update(q, uid, resourceId, etime, version, jsonData);
    }

    public ListF<CvDataPojo> getCvData(String uid, Instant from, Instant to, Option<Integer> limit) {
        String q = "Select * from cv_beauty WHERE uid = ? AND etime >= ? and etime <= ? ORDER BY etime ";

        SqlLimits limits = limit.map(l -> SqlLimits.first(l)).getOrElse(SqlLimits.all());

        q += limits.toMysqlLimits();

        return jdbcTemplate.query(q, (rs, rowNum) -> new CvDataPojo(
                rs.getString("uid"),
                rs.getString("resource_id"),
                new Instant(rs.getTimestamp("etime")),
                rs.getString("data")
        ), uid, from, to);
    }
}
