package ru.yandex.chemodan.app.cvdemo2.lb;

import java.util.concurrent.Executors;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.logbroker.DiskLbConsumerContextConfiguration;
import ru.yandex.chemodan.zk.registries.staff.YandexStaffUserRegistry;
import ru.yandex.commune.bazinga.BazingaTaskManager;
import ru.yandex.commune.salr.logreader.LogListener;
import ru.yandex.inside.logbroker.pull.consumer.LbSimpleAsyncLineListener;

/**
 * @author tolmalev
 */
@Configuration
@Import({
        DiskLbConsumerContextConfiguration.class
})
public class CvBeautyEventLoaderContextConfiguration {

    @Bean
    public LbSimpleAsyncLineListener lbConsumerListener(LogListener logListener) {
        return new LbSimpleAsyncLineListener(logListener, Executors.newFixedThreadPool(100));
    }

    @Bean
    public CvBeautyLogListener cvBeautyLogListener(BazingaTaskManager bazingaTaskManager,
            YandexStaffUserRegistry yandexStaffUserRegistry)
    {
        return new CvBeautyLogListener(bazingaTaskManager, yandexStaffUserRegistry);
    }
}
