package ru.yandex.chemodan.app.cvdemo2.lb;

import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.chemodan.app.cvdemo2.worker.CalculateImageBeautyHighPriorityTask;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.eventlog.events.MediaType;
import ru.yandex.chemodan.eventlog.events.Resource;
import ru.yandex.chemodan.eventlog.events.StandardMediaType;
import ru.yandex.chemodan.eventlog.events.eventlog.CallbackEventLogListener;
import ru.yandex.chemodan.eventlog.events.fs.FsEvent;
import ru.yandex.chemodan.zk.registries.staff.YandexStaffUserRegistry;
import ru.yandex.commune.bazinga.BazingaTaskManager;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author tolmalev
 */
public class CvBeautyLogListener extends CallbackEventLogListener {
    private static final Logger logger = LoggerFactory.getLogger(CvBeautyLogListener.class);

    public final DynamicProperty<Boolean> enableYandexIndexing =
            new DynamicProperty<>("cvdemo2-enable-yandex-indexing", false);

    private final BazingaTaskManager bazingaTaskManager;
    private final YandexStaffUserRegistry staffRegistry;

    public CvBeautyLogListener(BazingaTaskManager bazingaTaskManager,
            YandexStaffUserRegistry staffRegistry)
    {
        this.bazingaTaskManager = bazingaTaskManager;
        this.staffRegistry = staffRegistry;

        registerProcessor(FsEvent.class, this::processFsEvent);
    }

    public void processFsEvent(DataApiUserId uid, FsEvent event) {
        if (enableYandexIndexing.get() && staffRegistry.isStaffUser(uid.toPassportUid())) {
            logger.debug("Found event for staff user: {}, event: {}",
                    staffRegistry.findByExtUid(uid.toPassportUid()),
                    event
            );

            Resource resource = event.resourceChange.resource;

            if (resource.compoundType.mediaType.map(MediaType::getStandardType).isSome(StandardMediaType.IMAGE)) {
                logger.debug("Found image operation");
                bazingaTaskManager.schedule(new CalculateImageBeautyHighPriorityTask(uid.asString(),
                        uid.asString() + ":" + resource.fileId), Instant.now().plus(Duration.standardMinutes(2)));
            }
        }
    }
}
