package ru.yandex.chemodan.app.cvdemo2.worker;

import org.joda.time.Duration;

import ru.yandex.chemodan.app.cvdemo2.core.CvBeautyManager;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author tolmalev
 */
public class CalculateImageBeautyTask extends OnetimeTaskSupport<CalculateImageBeautyTask.Parameters> {

    private final CvBeautyManager manager;

    public CalculateImageBeautyTask(String uid, String resourceId) {
        super(new Parameters(uid, resourceId));
        manager = null;
    }

    public CalculateImageBeautyTask(CvBeautyManager manager) {
        super(Parameters.class);
        this.manager = manager;
    }

    @Override
    protected void execute(Parameters parameters, ExecutionContext context) throws Exception {
        manager.recalculateSignatureAndStore(parameters.uid, parameters.resourceId);
    }

    @Override
    public TaskQueueName queueName() {
        return CvDemo2TaskQueueName.CV_DEMO_CPU_INTENSIVE;
    }

    @Override
    public int priority() {
        return 10;
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(2);
    }

    @BenderBindAllFields
    public static class Parameters {
        public final String uid;
        public final String resourceId;

        public Parameters(String uid, String resourceId) {
            this.uid = uid;
            this.resourceId = resourceId;
        }
    }
}
