package ru.yandex.chemodan.app.cvdemo2.worker;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.cvdemo2.core.CvBeautyManager;
import ru.yandex.chemodan.bazinga.BazingaWorkerTaskQueues;
import ru.yandex.chemodan.bazinga.ChemodanBazingaWorkerContextConfiguration;
import ru.yandex.chemodan.mpfs.MpfsClient;
import ru.yandex.chemodan.util.encrypt.OpenSslAes256CbcCrypter;
import ru.yandex.commune.bazinga.pg.worker.PgBazingaWorkerConfiguration;
import ru.yandex.commune.bazinga.scheduler.CronTask;
import ru.yandex.commune.bazinga.scheduler.OnetimeTask;
import ru.yandex.commune.bazinga.scheduler.TaskFilter;
import ru.yandex.commune.bazinga.scheduler.TaskQueue;
import ru.yandex.inside.mulca.MulcaClient;
import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.impl.YtUtils;

/**
 * @author tolmalev
 */
@Configuration
@Import({
        ChemodanBazingaWorkerContextConfiguration.class,
})
public class CvDemo2WorkerContextConfiguration {
    @Bean
    public PgBazingaWorkerConfiguration pgBazingaWorkerConfiguration() {
        return new PgBazingaWorkerConfiguration(Cf.list(CvDemo2TaskQueueName.CV_DEMO_CRON));
    }

    @Bean
    public BazingaWorkerTaskQueues taskQueues(
            @Value("${cv.export.tasks.count:-10}")
                    int exportThreadCount,
            @Value("${cv.export.tasks.queue:-10}")
                    int exportQueueCount)
    {
        TaskQueue exportQueue = new TaskQueue(CvDemo2TaskQueueName.CV_DEMO_EXPORT, exportThreadCount, exportQueueCount);

        return new BazingaWorkerTaskQueues(
                Option.of(CvDemo2TaskQueueName.CV_DEMO_CRON),
                Option.of(CvDemo2TaskQueueName.CV_DEMO_REGULAR),
                Option.of(CvDemo2TaskQueueName.CV_DEMO_CPU_INTENSIVE),
                Cf.list(exportQueue));
    }

    @Bean
    public ReindexUserCvBeautyTask reindexUserTask(CvBeautyManager manager) {
        return new ReindexUserCvBeautyTask(manager);
    }

    @Bean
    public CalculateImageBeautyTask calculateImageSignatureTask(CvBeautyManager manager) {
        return new CalculateImageBeautyTask(manager);
    }

    @Bean
    public CalculateImageBeautyHighPriorityTask calculateImageSignatureHighPriorityTask(CvBeautyManager manager)
    {
        return new CalculateImageBeautyHighPriorityTask(manager);
    }

    @Bean
    public GenerateGifAnimationTask generateGifAnimationTask(MpfsClient mpfsClient, MulcaClient mulcaClient) {
        return new GenerateGifAnimationTask(mpfsClient, mulcaClient);
    }

    @Bean
    public TaskFilter taskFilter(
            @Value("${cv.enable.export:-false}") boolean enableExport,
            @Value("${cv.enable.reindex:-false}") boolean enableReindex,
            @Value("${cv.enable.gif:-false}") boolean enableGif)
    {
        return new TaskFilter() {
            @Override
            public boolean isEnabled(CronTask task) {
                return true;
            }

            @Override
            public boolean isEnabled(OnetimeTask task) {
                if (MakeCvExportTask.class.equals(task.getClass())) {
                    return enableExport;
                }

                if (ReindexUserCvBeautyTask.class.equals(task.getClass())
                        || CalculateImageBeautyTask.class.equals(task.getClass())
                        || CalculateImageBeautyHighPriorityTask.class.equals(task.getClass()))
                {
                    return enableReindex;
                }

                if (GenerateGifAnimationTask.class.equals(task.getClass())) {
                    return enableGif;
                }

                return true;
            }
        };
    }

    @Bean
    public MakeCvExportTask makeCvExportTask(
            Yt yt,
            MpfsClient mpfsClient,
            MulcaClient mulcaClient,
            @Value("${cv.export.hmac.key}") String hmacKey)
    {
        return new MakeCvExportTask(yt, mpfsClient, mulcaClient, new OpenSslAes256CbcCrypter(hmacKey));
    }

    @Bean
    public Yt dataApiYtClient(
            @Value("${yt.http.proxy}")
                    String ytHttpProxyUrl,
            @Value("${yt.user.token}")
                    String ytUserOauthToken)
    {
        return YtUtils.http(ytHttpProxyUrl, ytUserOauthToken);
    }
}
