package ru.yandex.chemodan.app.cvdemo2.worker;

import org.joda.time.Duration;

import ru.yandex.chemodan.app.cvdemo2.core.CvBeautyManager;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author tolmalev
 */
public class ReindexUserCvBeautyTask extends OnetimeTaskSupport<ReindexUserCvBeautyTask.Parameters> {

    private final CvBeautyManager manager;

    public ReindexUserCvBeautyTask(String uid) {
        super(new Parameters(uid));
        manager = null;
    }

    public ReindexUserCvBeautyTask(CvBeautyManager manager) {
        super(Parameters.class);
        this.manager = manager;
    }

    @Override
    protected void execute(Parameters parameters, ExecutionContext context) throws Exception {
        manager.reindexUser(parameters.uid, false);
    }

    @Override
    public TaskQueueName queueName() {
        return CvDemo2TaskQueueName.CV_DEMO_REGULAR;
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardDays(1);
    }

    @BenderBindAllFields
    public static class Parameters {
        public final String uid;

        public Parameters(String uid) {
            this.uid = uid;
        }
    }
}
