#include <contrib/libs/opencv/include/opencv2/opencv.hpp>
#include <contrib/libs/opencv/include/opencv2/video.hpp>
#include <iostream>
#include <cassert>
#include <cmath>
#include <fstream>

using namespace std;
using namespace cv;

void write_image(Mat img, char* prefix, int i) {
    char name[255];
    sprintf(name, "%s_%d.jpg", prefix, i);
    cerr << "writing " << name << endl;
    cerr.flush();
    imwrite(name, img);
}

int main(int argc, char **argv) {
    if(argc < 3) {
        cerr << "./stab file1.jpg [file2.jpg ...] out_prefix" << endl;
        return 0;
    }

    char* name_prefix = argv[argc - 1];

    vector<vector<Mat> > lists;
    vector<vector<Mat> > transforms;

    vector<Mat> first_list;

    Mat first_frame = imread(argv[1]);
    first_list.push_back(first_frame);
    lists.push_back(first_list);

    transforms.push_back(vector<Mat>());

    for (int i = 2; i < argc - 1; i++) {
        Mat frame = imread(argv[i]);
        cout << "processing: " << argv[i] << endl;
        cout.flush();

        bool found = false;
        for (int j = lists.size() - 1; j >= 0; j--) {
            for (int k = lists[j].size() - 1; k >= 0; k--) {
                cout << "try match with [" << j << "][" << k <<"]" << endl;
                //cout << "lists[" << j <<"][" << k <<"].size() = " << lists[j][k].size() << endl;
                Mat M = estimateRigidTransform(lists[j][k], frame, 0);
                //cout << M.size().width << "x" << M.size().height << endl;
                if (int(M.size().width) == 0) {
                    cout << "no match" << endl;
                    continue;
                } else {
                    cout << "has match" << endl;
                }

                found = true;
                Mat transformed;
                warpAffine(frame, transformed, M, frame.size(), INTER_NEAREST | WARP_INVERSE_MAP);

                if (k == (int)(lists[j].size() - 1)) {
                    lists[j].push_back(transformed);
                    transforms[j].push_back(M);
                    break;
                } else {
                    cout << "create new list\n";
                    vector<Mat> new_vec;
                    vector<Mat> new_transforms;
                    for (int f = 0; f <= k; f++)
                        new_vec.push_back(lists[j][f]);
                    for (int f = 0; f < k; f++)
                        new_transforms.push_back(transforms[j][f]);

                    new_vec.push_back(transformed);
                    new_transforms.push_back(M);

                    lists.push_back(new_vec);
                    transforms.push_back(new_transforms);
                }
            }
        }
        if (!found) {
            vector<Mat> new_vec;
            new_vec.push_back(frame);
            lists.push_back(new_vec);
            transforms.push_back(vector<Mat>());
        }
    }

    int max_i = 0;
    for (size_t i = 0; i < lists.size(); i++) {
        if (lists[i].size() > lists[max_i].size())
            max_i = i;
    }
    cout << "max list: " << max_i << ". size = " << lists[max_i].size() << endl;


    vector <Point2d> bounds;
    bounds.push_back(Point2d(0, 0));
    bounds.push_back(Point2d(0, first_frame.size().height));
    bounds.push_back(Point2d(first_frame.size().width, first_frame.size().height));
    bounds.push_back(Point2d(first_frame.size().width, 0));

    double crop_left = 0;
    double crop_top = 0;
    double crop_right = first_frame.size().width;
    double crop_bottom = first_frame.size().height;

    for (Point2f pt: bounds)
        cout << pt << " ";
    cout << endl;

    for (size_t i = 0; i < transforms[max_i].size(); i++) {
        //Mat M = transforms[max_i][i];
        //warpAffine(Mat(bounds), dst, transforms[max_i][i], first_frame.size(), INTER_NEAREST | WARP_INVERSE_MAP);
        //Point2f p(0, 0);
        //cout << Point2f(M.at<double>(0, 0) * p.x + M.at<double>(0, 1) * p.y + M.at<double>(0, 2), M.at<double>(1, 0) * p.x + M.at<double>(1, 1) * p.y + M.at<double>(1, 2)) << endl;
        //perspectiveTransform(bounds, new_bounds, transforms[max_i][i]);
        vector <Point2d> new_bounds;
        for (Point2d p: bounds) {
            Mat M;
            invertAffineTransform(transforms[max_i][i], M);

            Mat_<double> tmp(3, 1);
            tmp << p.x, p.y, 1.0;
            //cout << tmp << endl;
            Mat_<double> out = M * tmp;

            Point2d pt(out(0), out(1));
            cout << pt << " ";
            new_bounds.push_back(pt);
        }
        crop_left = max(crop_left, new_bounds[0].x);
        crop_left = max(crop_left, new_bounds[1].x);

        crop_right = min(crop_right, new_bounds[2].x);
        crop_right = min(crop_right, new_bounds[3].x);

        crop_top = max(crop_top, new_bounds[0].y);
        crop_top = max(crop_top, new_bounds[3].y);

        crop_bottom = min(crop_bottom, new_bounds[1].y);
        crop_bottom = min(crop_bottom, new_bounds[2].y);
        cout << endl;
    }

    cout << "crop " << crop_left << ", " << crop_top << ", " << crop_right << ", " << crop_bottom << endl;
    // bool vertical = first_frame.size().height > first_frame.size().width;
    // double crop_width = crop_right - crop_left;
    // double crop_height = crop_bottom - crop_top;



    for (size_t i = 0; i < lists[max_i].size(); i++) {
        //line(lists[max_i][i], Point2d(crop_left, crop_top), Point2d(crop_right, crop_bottom), Scalar(0,255,0), 1, 8, 0);
        Mat cropped(lists[max_i][i], Rect(crop_left, crop_top, crop_right - crop_left, crop_bottom - crop_top));
        write_image(cropped, name_prefix, i);
    }
}
