#!/usr/bin/env python
# -*- coding: utf-8 -*-

import yt.wrapper as yt

INPUT = '//home/yadisk/cv/previews/2017-10-03'
OUTPUT = '//home/yadisk/cv/previews/processed'


YT_PREFIX = '//home/yadisk/cv/imageparser/'

FILES = ['asm-all-5.0.3.jar', 'commons-lang-2.4.jar',
         'commons-logging-1.1.1.jar', 'commons-math3-3.2.jar',
         'devtools-jtest.jar', 'disk-cvdemo-jniwrapper.jar',
         'disk-cvyt.jar', 'dssm.conf',
         'dssm2/fall2016_clickbase_char_trigrams_dict_uniq.tsv',
         'dssm2/fall2016_clickbase_words_bigrams_dict_uniq.tsv',
         'dssm2/fall2016_clickbase_words_dict_uniq.tsv',
         'dssm2/i2t_ver7_img_body.cfg', 'dssm2/i2t_ver7_img_body.net',
         'dssm2/i2t_ver7_txt_prod.cfg', 'dssm2/i2t_ver7_txt_prod.net',
         'dssm2/imageparser/imageparser-new/i2t_ver7_img_body.net',
         'dssm2/imageparser/imageparser-new/imageparser.cfg',
         'dssm2/imageparser/imageparser-new/net.conf',
         'dssm2/imageparser/imageparser-old/compiled.net',
         'dssm2/imageparser/imageparser-old/imageparser.cfg',
         'dssm2/imageparser/imageparser-old/net.conf',
         'easymock-3.4.jar', 'findbugs-jsr305-3.0.0.jar',
         'hamcrest-core-1.3.jar', 'iceberg-bolts.jar',
         'iceberg-misc-bender-annotations.jar',
         'iceberg-misc-signal.jar', 'iceberg-misc.jar',
         'imageparser.conf', 'jackson-annotations-2.8.0.jar',
         'jackson-core-2.8.6.jar', 'jackson-databind-2.8.6.jar',
         'javax.servlet-api-3.0.1.jar', 'jmh-core-1.11.2.jar',
         'jmh-generator-annprocess-1.11.2.jar', 'joda-time-2.5.jar',
         'jopt-simple-4.6.jar', 'jsr250-api-1.0.jar', 'junit-4.12.jar',
         'libdisk-dssm-jniwrapper.so', 'libdisk-imageparser-jniwrapper.so',
         'libjniwrapper-main.so', 'log4j-1.2.17.jar',
         'log4j-api-2.5.jar', 'log4j-core-2.5.jar', 'objenesis-2.4.jar',
         'slf4j-api-1.7.12.jar', 'syslog4j-0.9.46.jar']


def make_yt_file_description(filepath):
    return '<file_name="{path}">{prefix}{path}'.format(path=filepath,
                                                       prefix=YT_PREFIX)

if __name__ == '__main__':
    yt.config['proxy']['url'] = 'freud'

    yt_files = [make_yt_file_description(filepath) for filepath in FILES]

    yt.run_map('java -Xmx4G -cp *:. -Djava.library.path=. ru.yandex.chemodan.app.cvyt.CvYtMain imageparser.conf',
               INPUT, OUTPUT,
               yt_files=yt_files,
               format=yt.JsonFormat(),
               spec={"pool": "yadisk-cloud", "scheduling_tag": "external",
                     "scheduling_tag_filter": "external",
                     "max_failed_job_count": 10000,
                     "suspend_operation_if_account_limit_exceeded": "true",
                     "mapper": {"memory_limit": 1073741824}},
               sync=False)
