package ru.yandex.chemodan.app.cvyt;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.file.Paths;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;

import ru.yandex.bolts.collection.Option;
import ru.yandex.function.Processor;
import ru.yandex.jniwrapper.ImmutableJniWrapperConfig;
import ru.yandex.jniwrapper.JniWrapper;
import ru.yandex.jniwrapper.JniWrapperConfigBuilder;
import ru.yandex.jniwrapper.JniWrapperException;
import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.codec.FastBase64Coder;
import ru.yandex.parser.config.IniConfig;


/**
 * @author yashunsky
 */
public class CvYtMain {
    private final static ObjectMapper mapper = new ObjectMapper();

    public static void main(final String... args) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));

        Processor<byte[], String, JniWrapperException> processor =
                JniWrapper.create(
                        new ImmutableJniWrapperConfig(
                                new JniWrapperConfigBuilder(
                                        new IniConfig(Paths.get(args[0])))))
                        .apply("", null);

        reader.lines().forEach(jsonString -> {
            getImage(jsonString).forEach(image ->  {
                try {
                    JsonNode node = mapper.readTree(processor.process(image.raw));
                    String i2t = node.get("i2t").asText();

                    String output = "{\"mulca_id\": \"" + image.mulcaId + "\", \"i2t\": [" + i2t + "]}";
                    System.out.println(output);
                } catch (Throwable t) {
                    ExceptionUtils.throwIfUnrecoverable(t);
                }
            });
        });

    }

    private static Option<Image> getImage(String jsonString) {
        try {
            JsonNode node = mapper.readTree(jsonString);
            String mulcaId = node.get("mulca_id").textValue();
            String base64Image = node.get("base64image").textValue();
            byte[] image = FastBase64Coder.decode(base64Image.toCharArray());

            return Option.of(new Image(mulcaId, image));
        } catch (Throwable t) {
            ExceptionUtils.throwIfUnrecoverable(t);
            return Option.empty();
        }
    }

    private static class Image {
        public final String mulcaId;
        public final byte[] raw;

        public Image(String mulcaId, byte[] raw) {
            this.mulcaId = mulcaId;
            this.raw = raw;
        }
    }
}
