package ru.yandex.chemodan.app.datasyncadmin;

import java.lang.reflect.Field;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.core.dao.usermeta.UserMetaManager;
import ru.yandex.chemodan.app.dataapi.core.datasources.disk.DiskDataSource;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;
import ru.yandex.chemodan.app.dataapi.web.admin.DatabaseInfoAdminPage;
import ru.yandex.chemodan.app.dataapi.web.admin.UserDatabasesAdminPage;
import ru.yandex.chemodan.app.datasyncadmin.idm.IdmAccessRoutines;
import ru.yandex.commune.admin.web.AdminApp;
import ru.yandex.commune.admin.web.AdminMenuLink;
import ru.yandex.commune.admin.web.AdminMenuManager;

/**
 * @author yashunsky
 */
@Configuration
public class AdminPagesContextConfiguration {
    @Autowired
    private AdminApp adminApp;

    @PostConstruct
    public void cleanMenu() {
        try {
            Field adminMenuManagerField = AdminApp.class.getDeclaredField("adminMenuManager");
            adminMenuManagerField.setAccessible(true);
            AdminMenuManager adminMenuManager = (AdminMenuManager) adminMenuManagerField.get(adminApp);
            Field linksField = AdminMenuManager.class.getDeclaredField("links");
            linksField.setAccessible(true);
            ListF<AdminMenuLink> links = (ListF<AdminMenuLink>) linksField.get(adminMenuManager);
            Cf.toList(links);
            links.removeAllTs(links.filter(l -> !l.getTitle().equals("Data")));
        } catch (NoSuchFieldException | IllegalAccessException ignore) {
        }
    }

    @Bean
    public UserDatabasesAdminPage userDatabasesAdminPage(
            UserMetaManager userMetaManager,
            DiskDataSource dataApiManager, IdmAccessRoutines accessRoutines)
    {
        UserDatabasesAdminPage page = new UserDatabasesAdminPage(userMetaManager, dataApiManager, accessRoutines);
        adminApp.registerAdminPage(Option.of("Data"), page);
        return page;
    }

    @Bean
    public DatabaseInfoAdminPage databaseInfoAdminPage(UserMetaManager userMetaManager,
            DataApiManager dataApiManager, IdmAccessRoutines accessRoutines)
    {
        DatabaseInfoAdminPage page = new DatabaseInfoAdminPage(userMetaManager, dataApiManager, accessRoutines);
        adminApp.registerHiddenAdminPage(page);
        return page;
    }
}
