package ru.yandex.chemodan.app.datasyncadmin;

/**
 * @author yashunsky
 */

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.app.dataapi.NS;
import ru.yandex.chemodan.app.dataapi.api.db.ref.external.ExternalDatabasesContextConfiguration;
import ru.yandex.chemodan.app.dataapi.api.db.ref.external.ExternalDatabasesRegistry;
import ru.yandex.chemodan.app.dataapi.apps.AppsContextConfiguration;
import ru.yandex.chemodan.app.dataapi.apps.settings.AppSettingsRegistry;
import ru.yandex.chemodan.app.dataapi.core.DatabasesContextConfiguration;
import ru.yandex.chemodan.app.dataapi.core.dao.DataApiUserMetaContextConfiguration;
import ru.yandex.chemodan.app.dataapi.core.dao.JdbcShardContextConfiguration;
import ru.yandex.chemodan.app.dataapi.core.generic.TypeSettingsRegistry;
import ru.yandex.chemodan.app.dataapi.core.generic.TypeSettingsRegistryContextConfiguration;
import ru.yandex.chemodan.app.dataapi.utils.elliptics.EllipticsContextConfiguration;
import ru.yandex.chemodan.app.datasyncadmin.admin.CheckAccessInterceptorsHolder;
import ru.yandex.chemodan.app.datasyncadmin.databases.AccessibleDatabasesContextConfiguration;
import ru.yandex.chemodan.app.datasyncadmin.databases.DatabasesRegistry;
import ru.yandex.chemodan.app.datasyncadmin.idm.IdmAccessRoutines;
import ru.yandex.chemodan.app.datasyncadmin.idm.IdmRegistriesRoutines;
import ru.yandex.chemodan.app.datasyncadmin.users.UsersRegistry;
import ru.yandex.chemodan.app.datasyncadmin.users.UsersRegistryContextConfiguration;
import ru.yandex.chemodan.app.datasyncadmin.web.WebContextConfiguration;
import ru.yandex.chemodan.boot.admin.CustomAdminActionInterceptorsHolder;
import ru.yandex.chemodan.util.idm.IdmActions;
import ru.yandex.chemodan.util.jdbc.JdbcDatabaseConfiguratorContextConfiguration;
import ru.yandex.chemodan.util.web.A3JettyConfiguration;
import ru.yandex.chemodan.util.web.A3JettyContextConfiguration;

@Configuration
@Import(value = {
        A3JettyContextConfiguration.class,
        AccessibleDatabasesContextConfiguration.class,
        AppsContextConfiguration.class,
        DataApiUserMetaContextConfiguration.class,
        DatabasesContextConfiguration.class,
        EllipticsContextConfiguration.class,
        ExternalDatabasesContextConfiguration.class,
        JdbcDatabaseConfiguratorContextConfiguration.class,
        JdbcShardContextConfiguration.class,
        AdminPagesContextConfiguration.class,
        TypeSettingsRegistryContextConfiguration.class,
        UsersRegistryContextConfiguration.class,
        WebContextConfiguration.class
})
public class DataSyncAdminContextConfiguration {
    @Bean
    public A3JettyConfiguration a3JettyServletsConfiguration() {
        return new A3JettyConfiguration(Tuple2List.fromPairs(
                "/idm/*", NS.API
        ));
    }

    @Bean
    public IdmRegistriesRoutines registriesRoutines(
            DatabasesRegistry databasesRegistry,
            AppSettingsRegistry appSettingsRegistry,
            ExternalDatabasesRegistry externalDatabasesRegistry,
            TypeSettingsRegistry typeSettingsRegistry,
            UsersRegistry usersRegistry)
    {
        return new IdmRegistriesRoutines(
                databasesRegistry, appSettingsRegistry, externalDatabasesRegistry, typeSettingsRegistry, usersRegistry);
    }

    @Bean
    public IdmActions idmActions(IdmRegistriesRoutines registriesRoutines) {
        return new IdmActions(registriesRoutines);
    }

    @Bean
    public IdmAccessRoutines idmAccessibleDatabasesFilter(UsersRegistry usersRegistry) {
        return new IdmAccessRoutines(usersRegistry);
    }

    @Bean
    public CustomAdminActionInterceptorsHolder customActionInterceptors(IdmAccessRoutines idmAccessRoutines) {
        return new CheckAccessInterceptorsHolder(idmAccessRoutines);
    }
}
