package ru.yandex.chemodan.app.datasyncadmin;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.boot.ChemodanCommonContextConfiguration;
import ru.yandex.chemodan.boot.ChemodanMainSupport;
import ru.yandex.misc.db.monica.JdbcMetricsSwitch;
import ru.yandex.misc.version.AppName;
import ru.yandex.misc.version.SimpleAppName;

/**
 * @author yashunsky
 */
public class DataSyncAdminMain extends ChemodanMainSupport {

    public static void main(String[] args) {
        JdbcMetricsSwitch.ENABLED = true;
        JdbcMetricsSwitch.COMMAND_METRICS_ENABLED = true;
        new DataSyncAdminMain().runMain(args);
    }

    @Override
    public AppName applicationName() {
        return new SimpleAppName("dataapi", "datasync-admin");
    }

    @Override
    public ListF<Class<?>> applicationSpecificContextPath() {
        return Cf.list(
                ChemodanCommonContextConfiguration.class,
                DataSyncAdminContextConfiguration.class);
    }
}
